/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugins.authentication.api.tsv.UserRateLimitDTO;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthAuditService;
import com.atlassian.plugins.authentication.api.tsv.service.RateLimitingService;
import com.atlassian.plugins.authentication.tsv.model.RateLimitingResult;
import com.atlassian.plugins.authentication.tsv.model.UserRateLimit;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRateLimitingService
implements RateLimitingService {
    private static final Logger log = LoggerFactory.getLogger(DefaultRateLimitingService.class);
    private final ConcurrentMap<String, UserRateLimit> userRateLimits = new ConcurrentHashMap<String, UserRateLimit>();
    private final AuthAuditService authAuditService;

    public DefaultRateLimitingService(AuthAuditService authAuditService) {
        this.authAuditService = authAuditService;
    }

    public RateLimitingResult isRequestAllowed(@Nonnull String userKey) {
        RateLimitingResult result = this.getHandledRequestState(userKey, userRateLimit -> {}, userRateLimit -> log.debug("For user {}, the current limits are {}", (Object)userKey, userRateLimit));
        log.debug("Can proceed for user: {}? {}", (Object)userKey, (Object)result);
        return result;
    }

    public RateLimitingResult logFailedRequest(@Nonnull String userKey) {
        return this.getHandledRequestState(userKey, UserRateLimit::incrementConsecutiveFailures, userRateLimit -> log.debug("Failed request logged for user: {}. New rate limits are {}", (Object)userKey, userRateLimit));
    }

    public RateLimitingResult logSuccessfulRequest(@Nonnull String userKey) {
        RateLimitingResult result = this.isRequestAllowed(userKey);
        if (result.isRequestAllowed()) {
            log.debug("Deleting entry for user {} from rate limiting cache", (Object)userKey);
            this.userRateLimits.remove(userKey);
            result.setUserRateLimitDTO(this.mapUserRateLimitToDTO(new UserRateLimit(userKey)));
        }
        return result;
    }

    public UserRateLimitDTO getUserRateLimit(@Nonnull String userKey) {
        UserRateLimit userRateLimit = this.userRateLimits.compute(userKey, (key, limit) -> {
            if (limit == null) {
                limit = new UserRateLimit(userKey);
            }
            return limit;
        });
        return this.mapUserRateLimitToDTO(userRateLimit);
    }

    @VisibleForTesting
    public void setUserRateLimit(@Nonnull UserRateLimit userRateLimit) {
        this.userRateLimits.put(userRateLimit.getUserKey(), userRateLimit);
    }

    @VisibleForTesting
    public void setUserRateLimit(@Nonnull UserRateLimitDTO userRateLimit) {
        this.setUserRateLimit(new UserRateLimit(userRateLimit.userKey(), userRateLimit.consecutiveFailures(), userRateLimit.nextBackoffInSeconds(), userRateLimit.nextAllowedTime()));
    }

    @VisibleForTesting
    public void cleanupUserRateLimit(@Nonnull String userKey) {
        this.userRateLimits.remove(userKey);
    }

    private boolean hasBackOffTimeElapsed(UserRateLimit userRateLimit) {
        return userRateLimit.getNextAllowedTime() <= Instant.now().getEpochSecond();
    }

    private UserRateLimitDTO mapUserRateLimitToDTO(UserRateLimit userRateLimit) {
        return new UserRateLimitDTO(userRateLimit.getUserKey(), userRateLimit.getConsecutiveFailures(), userRateLimit.getNextBackoffInSeconds(), userRateLimit.getNextAllowedTime());
    }

    private RateLimitingResult getHandledRequestState(String userKey, Consumer<UserRateLimit> onRequestAllowedFunction, Consumer<UserRateLimitDTO> logFunction) {
        RateLimitingResult result = new RateLimitingResult();
        this.userRateLimits.compute(userKey, (key, userRateLimit) -> {
            boolean isRequestAllowed;
            if (userRateLimit == null) {
                userRateLimit = new UserRateLimit(userKey);
            }
            if (isRequestAllowed = this.hasBackOffTimeElapsed((UserRateLimit)userRateLimit)) {
                onRequestAllowedFunction.accept((UserRateLimit)userRateLimit);
            }
            result.setRequestAllowed(isRequestAllowed);
            result.setUserRateLimitDTO(this.mapUserRateLimitToDTO((UserRateLimit)userRateLimit));
            return userRateLimit;
        });
        boolean requestAllowed = result.isRequestAllowed();
        if (!requestAllowed) {
            this.authAuditService.logUserRateLimited(result.getUserRateLimitDTO());
        }
        logFunction.accept(result.getUserRateLimitDTO());
        return result;
    }
}

