/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.onetime.core.TOTP;
import com.atlassian.onetime.model.EmailAddress;
import com.atlassian.onetime.model.Issuer;
import com.atlassian.onetime.model.TOTPSecret;
import com.atlassian.onetime.service.TOTPService;
import com.atlassian.onetime.service.TOTPVerificationResult;
import com.atlassian.plugins.authentication.api.tsv.internal.exception.EnrollmentNotFoundException;
import com.atlassian.plugins.authentication.api.tsv.service.SeenTotpCodesService;
import com.atlassian.plugins.authentication.encryption.EncryptionService;
import com.atlassian.plugins.authentication.encryption.model.SealedSecret;
import com.atlassian.plugins.authentication.encryption.model.Secret;
import com.atlassian.plugins.authentication.tsv.db.TotpUserEnrollmentDao;
import com.atlassian.plugins.authentication.tsv.exception.DecryptionFailedException;
import com.atlassian.plugins.authentication.tsv.model.TotpUserEnrollment;
import com.atlassian.plugins.authentication.tsv.service.InternalTotpService;
import com.atlassian.plugins.authentication.tsv.service.TotpIssuerService;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.annotation.Nonnull;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTotpService
implements InternalTotpService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTotpService.class);
    private final I18nResolver i18nResolver;
    private final TotpUserEnrollmentDao totpUserEnrollmentDao;
    private final TOTPService oneTimetotpService;
    private final TotpIssuerService totpIssuerService;
    private final EncryptionService encryptionService;
    private final SeenTotpCodesService seenTotpCodesService;

    public DefaultTotpService(TotpIssuerService totpIssuerService, I18nResolver i18nResolver, TotpUserEnrollmentDao totpUserEnrollmentDao, TOTPService oneTimetotpService, EncryptionService encryptionService, SeenTotpCodesService seenTotpCodesService) {
        this.i18nResolver = i18nResolver;
        this.totpUserEnrollmentDao = totpUserEnrollmentDao;
        this.oneTimetotpService = oneTimetotpService;
        this.totpIssuerService = totpIssuerService;
        this.encryptionService = encryptionService;
        this.seenTotpCodesService = seenTotpCodesService;
    }

    @Override
    public boolean isTotpCodeValid(@Nonnull String userKey, @Nonnull String code) {
        TotpUserEnrollment enrollment = this.totpUserEnrollmentDao.findTotpUserEnrollmentByUserKey(userKey).orElseThrow(EnrollmentNotFoundException::new);
        boolean valid = this.isTotpCodeValid(userKey, code, enrollment.secret());
        log.debug("TOTP code validation result for user-key {} is {}", (Object)userKey, (Object)valid);
        return valid;
    }

    @Override
    public boolean isTotpCodeValid(@Nonnull String userKey, @Nonnull String code, @Nonnull String serializedSecret) {
        if (!this.seenTotpCodesService.validateTotpCodeUsage(userKey, code)) {
            return false;
        }
        Secret unSealedSecret = this.encryptionService.unseal(Secret.of(serializedSecret));
        if (unSealedSecret instanceof SealedSecret) {
            throw new DecryptionFailedException("Decryption failed during totp code validation for user-key " + userKey);
        }
        TOTP totpCode = new TOTP(code);
        TOTPVerificationResult result = this.oneTimetotpService.verify(totpCode, TOTPSecret.Companion.fromBase32EncodedString(Secret.rawValue(unSealedSecret)));
        return result.isSuccess();
    }

    @Override
    public URI generateTOTPUrl(@Nonnull String username, @Nonnull String base32EncodedSecret) {
        String issuer = this.totpIssuerService.getIssuer();
        return this.oneTimetotpService.generateTOTPUrl(TOTPSecret.Companion.fromBase32EncodedString(base32EncodedSecret), new EmailAddress(username), new Issuer(issuer));
    }
}

