/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRandomProvider {
    private static final Logger log = LoggerFactory.getLogger(SecureRandomProvider.class);
    private static final String ALGO_NAME = "DRBG";
    private static final String ALGO_PROVIDER = "SUN";

    public SecureRandom getSecureRandom() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        static final SecureRandom INSTANCE = Holder.getInstance();

        private Holder() {
        }

        private static SecureRandom getInstance() {
            try {
                log.debug("Creating instance of Secure Random with algo {} and provider {}", (Object)SecureRandomProvider.ALGO_NAME, (Object)SecureRandomProvider.ALGO_PROVIDER);
                return SecureRandom.getInstance(SecureRandomProvider.ALGO_NAME, SecureRandomProvider.ALGO_PROVIDER);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                log.error("Failed to create SecureRandom instance with algo {} and provider {}", new Object[]{SecureRandomProvider.ALGO_NAME, SecureRandomProvider.ALGO_PROVIDER, e});
                return new SecureRandom();
            }
        }
    }
}

