/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import java.util.Optional;

public class SsoManagementStatusService {
    private final CrowdService crowdService;

    public SsoManagementStatusService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public boolean isUserManagedBySsoProvider(String userName, HttpServletRequest request) {
        boolean userWasLoggedWithSso = Optional.ofNullable(request.getSession(false)).map(session -> Objects.equals(session.getAttribute("com.atlassian.plugins.authentication.userLoggedInWithSso"), true)).orElse(false);
        if (userWasLoggedWithSso) {
            return true;
        }
        Iterable matchingUsers = this.crowdService.search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)userName), Restriction.on((Property)PropertyUtils.ofTypeString((String)"jit_idp_id")).containing((Object)"")})).returningAtMost(1));
        return matchingUsers.iterator().hasNext();
    }
}

