/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.plugins.authentication.tsv.rest.model.conversation.LoginConversation;
import com.atlassian.plugins.authentication.tsv.rest.model.conversation.TotpEnrollConversation;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class TotpConversationService {
    private static final long ENROLL_CONVERSATION_LIFETIME = Long.getLong("atlassian.authentication.2sv.enroll.conversation.lifetime", Duration.ofMinutes(10L).getSeconds());
    private static final long LOGIN_CONVERSATION_LIFETIME = Long.getLong("atlassian.authentication.2sv.login.conversation.lifetime", Duration.ofMinutes(10L).getSeconds());
    private static final long CONVERSATION_CACHE_SIZE = Long.getLong("atlassian.authentication.2sv.conversation.cache.size", 100000L);
    private final Cache<Object, TotpEnrollConversation> enrollConversationCache = CacheBuilder.newBuilder().expireAfterWrite(ENROLL_CONVERSATION_LIFETIME, TimeUnit.SECONDS).maximumSize(CONVERSATION_CACHE_SIZE).build();
    private final Cache<Object, LoginConversation> loginConversationCache = CacheBuilder.newBuilder().expireAfterWrite(LOGIN_CONVERSATION_LIFETIME, TimeUnit.SECONDS).maximumSize(CONVERSATION_CACHE_SIZE).build();

    public void addEnrollConversation(@Nonnull String key, @Nonnull TotpEnrollConversation conversation) {
        this.enrollConversationCache.put((Object)key, (Object)conversation);
    }

    public Optional<TotpEnrollConversation> retrieveEnrollConversation(@Nonnull String key) {
        return Optional.ofNullable((TotpEnrollConversation)this.enrollConversationCache.getIfPresent((Object)key));
    }

    public void invalidateEnrollmentConversation(@Nonnull String key) {
        this.enrollConversationCache.invalidate((Object)key);
    }

    public void addLoginConversation(@Nonnull LoginConversation conversation) {
        this.loginConversationCache.put((Object)conversation.getConversationId(), (Object)conversation);
    }

    public Optional<LoginConversation> retrieveLoginConversation(@Nonnull String key) {
        return Optional.ofNullable((LoginConversation)this.loginConversationCache.getIfPresent((Object)key));
    }

    public void invalidateLoginConversation(@Nonnull String key) {
        this.loginConversationCache.invalidate((Object)key);
    }
}

