/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.annotation.Nonnull;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;

public abstract class TotpIssuerService {
    protected final ApplicationProperties salApplicationProperties;

    protected TotpIssuerService(ApplicationProperties salApplicationProperties) {
        this.salApplicationProperties = salApplicationProperties;
    }

    protected abstract Optional<String> getProductTitle();

    @Nonnull
    public String getIssuer() {
        return this.getProductTitle().filter(x -> !x.isBlank()).orElseGet(() -> {
            try {
                URL url = new URL(this.salApplicationProperties.getBaseUrl(UrlMode.CANONICAL));
                return url.getHost() + url.getPath();
            }
            catch (MalformedURLException ex) {
                return this.salApplicationProperties.getDisplayName();
            }
        });
    }
}

