/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.plugins.authentication.api.tsv.internal.exception.InvalidTotpCodeException;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthAuditService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.VerificationMethod;
import com.atlassian.plugins.authentication.tsv.exception.ConversationNotFoundException;
import com.atlassian.plugins.authentication.tsv.model.ConversationType;
import com.atlassian.plugins.authentication.tsv.model.Method;
import com.atlassian.plugins.authentication.tsv.rest.model.conversation.LoginConversation;
import com.atlassian.plugins.authentication.tsv.service.InternalTotpService;
import com.atlassian.plugins.authentication.tsv.service.TotpConversationService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.CrowdSsoCookieData;
import com.atlassian.plugins.authentication.tsv.service.session.SessionService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotpLoginService {
    private static final Logger log = LoggerFactory.getLogger(TotpLoginService.class);
    private final InternalTotpService totpService;
    private final TotpConversationService totpConversationService;
    private final I18nResolver i18nResolver;
    private final SessionService sessionService;
    private final UserManager userManager;
    private final AuthAuditService authAuditService;

    public TotpLoginService(InternalTotpService totpService, TotpConversationService totpConversationService, I18nResolver i18nResolver, SessionService sessionService, UserManager userManager, AuthAuditService authAuditService) {
        this.totpService = totpService;
        this.totpConversationService = totpConversationService;
        this.i18nResolver = i18nResolver;
        this.sessionService = sessionService;
        this.userManager = userManager;
        this.authAuditService = authAuditService;
    }

    public void completeLoginUsingTotpVerification(@Nonnull String conversationId, @Nonnull String totpCode, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ConversationNotFoundException, InvalidTotpCodeException {
        LoginConversation conversation = this.getConversation(conversationId);
        log.debug("Validating TOTP code for login for user-key {}", (Object)conversation.getUserKey());
        if (!this.totpService.isTotpCodeValid(conversation.getUserKey(), totpCode)) {
            log.debug("Invalid TOTP code entered for user-key {}", (Object)conversation.getUserKey());
            this.authAuditService.logTsvLoginFailure(new UserKey(conversation.getUserKey()), VerificationMethod.TOTP);
            throw new InvalidTotpCodeException();
        }
        this.totpConversationService.invalidateLoginConversation(conversation.getConversationId());
        this.sessionService.createNewSession(request, response, conversation.getUserKey(), conversation.getRememberMe(), SessionService.AuthenticationType.LOGIN_FORM, conversation.getCrowdSsoCookieData());
        this.authAuditService.logTsvLoginSuccess(new UserKey(conversation.getUserKey()), VerificationMethod.TOTP);
        log.debug("Session created for user-key {}", (Object)conversation.getUserKey());
    }

    @Nonnull
    public LoginConversation startLoginConversation(@Nonnull String userKey, @Nonnull String userName, boolean rememberMe, @Nullable CrowdSsoCookieData ssoCrowdTokenCookie) {
        LoginConversation loginConversation = new LoginConversation(userKey, userName, Method.TOTP, rememberMe, ssoCrowdTokenCookie);
        this.totpConversationService.addLoginConversation(loginConversation);
        return loginConversation;
    }

    private LoginConversation getConversation(@Nonnull String conversationId) throws ConversationNotFoundException {
        return this.totpConversationService.retrieveLoginConversation(conversationId).orElseThrow(() -> new ConversationNotFoundException(ConversationType.AUTHENTICATION));
    }
}

