/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.audit;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.AuditLogEntry;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.audit.ImmutableAuditLogChangeset;
import com.atlassian.crowd.audit.ImmutableAuditLogEntity;
import com.atlassian.crowd.audit.ImmutableAuditLogEntry;
import com.atlassian.plugins.authentication.common.audit.AuthAuditCategory;
import com.atlassian.plugins.authentication.common.audit.AuthAuditResourceType;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CrowdAuditLogMapper {
    private final I18nResolver i18nResolver;

    public CrowdAuditLogMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public AuditLogChangeset mapAuditLogChangeset(AuditEvent auditEvent) {
        return new ImmutableAuditLogChangeset.Builder().setEventType(CrowdAuditLogMapper.mapEventType(auditEvent)).setEntities(CrowdAuditLogMapper.mapEntities(auditEvent.getAffectedObjects())).addEntries(this.mapEntries(auditEvent.getChangedValues())).setEventMessage(this.i18nResolver.getText(auditEvent.getActionI18nKey())).build();
    }

    private static AuditLogEventType mapEventType(AuditEvent auditEvent) {
        return switch (AuthAuditCategory.fromCategoryKey(auditEvent.getCategoryI18nKey())) {
            case AuthAuditCategory.TWO_STEP_VERIFICATION_CONFIGURATION -> AuditLogEventType.TWO_STEP_VERIFICATION_CONFIGURATION_MODIFIED;
            case AuthAuditCategory.IDENTITY_VERIFICATION -> AuditLogEventType.TWO_STEP_VERIFICATION_IDENTITY_VERIFICATION_PERFORMED;
            case AuthAuditCategory.SSO_CONFIGURATION -> AuditLogEventType.SSO_CONFIGURATION_MODIFIED;
            case AuthAuditCategory.BASIC_AUTH_CONFIGURATION -> AuditLogEventType.BASIC_AUTH_CONFIGURATION_MODIFIED;
            default -> AuditLogEventType.OTHER;
        };
    }

    private static List<ImmutableAuditLogEntity> mapEntities(List<AuditResource> affectedObjects) {
        return affectedObjects.stream().map(CrowdAuditLogMapper::mapEntity).toList();
    }

    private static ImmutableAuditLogEntity mapEntity(AuditResource auditResource) {
        return new ImmutableAuditLogEntity.Builder().setEntityType(CrowdAuditLogMapper.mapEntityType(auditResource)).setEntityName(auditResource.getName()).build();
    }

    private static AuditLogEntityType mapEntityType(AuditResource auditResource) {
        return switch (AuthAuditResourceType.fromValue(auditResource.getType())) {
            case AuthAuditResourceType.USER -> AuditLogEntityType.USER;
            case AuthAuditResourceType.IDP_CONFIGURATION -> AuditLogEntityType.CONFIGURATION;
            default -> AuditLogEntityType.OTHER;
        };
    }

    private Collection<AuditLogEntry> mapEntries(List<ChangedValue> changedValues) {
        return changedValues.stream().map(this::mapEntry).toList();
    }

    private AuditLogEntry mapEntry(ChangedValue changedValue) {
        String propertyName = StringUtils.isNotBlank((CharSequence)changedValue.getKey()) ? changedValue.getKey() : this.i18nResolver.getText(changedValue.getI18nKey());
        return new ImmutableAuditLogEntry.Builder().setPropertyName(propertyName).setOldValue(changedValue.getFrom()).setNewValue(changedValue.getTo()).build();
    }
}

