/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.api.tsv.UserRateLimitDTO;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthAuditService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.VerificationMethod;
import com.atlassian.plugins.authentication.common.analytics.events.IdentityVerificationAnalyticsEvent;
import com.atlassian.plugins.authentication.common.audit.AuthAuditCategory;
import com.atlassian.plugins.authentication.common.audit.AuthAuditResourceType;
import com.atlassian.plugins.authentication.tsv.service.enforcement.EnforcementService;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;

public class DefaultAuthAuditService
implements AuthAuditService {
    private static final String I18N_ENFORCED_LABEL = "authentication.two-step-verification.audit.enforced.label";
    private static final String I18N_METHOD_LABEL = "authentication.two-step-verification.audit.method.label";
    private static final String I18N_RATE_LIMIT_FAILURES = "authentication.two-step-verification.audit.identity.verification.rate-limited.consecutive-failures";
    private static final String I18N_NEXT_BACKOFF_IN_SECONDS = "authentication.two-step-verification.audit.identity.verification.rate-limited.next-backoff-in-seconds";
    private static final String I18N_NEXT_ALLOWED_TIME = "authentication.two-step-verification.audit.identity.verification.rate-limited.next-allowed-time";
    private final AuditService auditService;
    private final UserManager userManager;
    private final TimeZoneManager timeZoneManager;
    private final EventPublisher eventPublisher;
    private final EnforcementService enforcementService;

    public DefaultAuthAuditService(AuditService auditService, UserManager userManager, TimeZoneManager timeZoneManager, EventPublisher eventPublisher, EnforcementService enforcementService) {
        this.auditService = auditService;
        this.userManager = userManager;
        this.timeZoneManager = timeZoneManager;
        this.eventPublisher = eventPublisher;
        this.enforcementService = enforcementService;
    }

    public void logTsvEnabled(@Nonnull UserKey userKey, @Nonnull VerificationMethod method, boolean enforced) {
        String actionKey = "authentication.two-step-verification.audit.configuration.tsv.enabled.action";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.TWO_STEP_VERIFICATION_CONFIGURATION.getKey(), (String)"authentication.two-step-verification.audit.configuration.tsv.enabled.action", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(userKey)).extraAttributes(List.of(AuditAttribute.fromI18nKeys((String)I18N_METHOD_LABEL, (String)method.name()).build(), AuditAttribute.fromI18nKeys((String)I18N_ENFORCED_LABEL, (String)String.valueOf(enforced)).build())).build();
        this.auditService.audit(event);
    }

    public void logTsvDisabled(@Nonnull UserKey userKey, @Nonnull VerificationMethod method) {
        String actionKey = "authentication.two-step-verification.audit.configuration.tsv.disabled.action";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.TWO_STEP_VERIFICATION_CONFIGURATION.getKey(), (String)"authentication.two-step-verification.audit.configuration.tsv.disabled.action", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(userKey)).extraAttribute(AuditAttribute.fromI18nKeys((String)I18N_METHOD_LABEL, (String)method.name()).build()).build();
        this.auditService.audit(event);
    }

    public void logChangeAuthenticationApp(@Nonnull String userName, @Nonnull VerificationMethod method) {
        String actionKey = "authentication.two-step-verification.audit.configuration.tsv.reset.action";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.TWO_STEP_VERIFICATION_CONFIGURATION.getKey(), (String)"authentication.two-step-verification.audit.configuration.tsv.reset.action", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(userName)).extraAttribute(AuditAttribute.fromI18nKeys((String)I18N_METHOD_LABEL, (String)method.name()).build()).build();
        this.auditService.audit(event);
    }

    public void logRecoveryCodeRegenerated(@Nonnull String username) {
        String actionKey = "authentication.two-step-verification.audit.configuration.recovery-key.regenerated.action";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.TWO_STEP_VERIFICATION_CONFIGURATION.getKey(), (String)"authentication.two-step-verification.audit.configuration.recovery-key.regenerated.action", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(username)).build();
        this.auditService.audit(event);
    }

    public void logTsvLoginSuccess(@Nonnull UserKey userKey, @Nonnull VerificationMethod method) {
        String actionKey = "authentication.two-step-verification.audit.identity.verification.login.successful";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.IDENTITY_VERIFICATION.getKey(), (String)"authentication.two-step-verification.audit.identity.verification.login.successful", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(userKey)).extraAttribute(AuditAttribute.fromI18nKeys((String)I18N_METHOD_LABEL, (String)method.name()).build()).build();
        this.auditService.audit(event);
        this.eventPublisher.publish((Object)new IdentityVerificationAnalyticsEvent(userKey.getStringValue(), this.enforcementService.isHighRiskAuthorityUser(userKey), method));
    }

    public void logTsvLoginFailure(@Nonnull UserKey userKey, @Nonnull VerificationMethod method) {
        String actionKey = "authentication.two-step-verification.audit.identity.verification.login.failed";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.IDENTITY_VERIFICATION.getKey(), (String)"authentication.two-step-verification.audit.identity.verification.login.failed", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(userKey)).extraAttribute(AuditAttribute.fromI18nKeys((String)I18N_METHOD_LABEL, (String)method.name()).build()).build();
        this.auditService.audit(event);
    }

    public void logTsvSessionElevationSuccess(@Nonnull String username, @Nonnull VerificationMethod method) {
        String actionKey = "authentication.two-step-verification.audit.identity.verification.elevated-session.successful";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.IDENTITY_VERIFICATION.getKey(), (String)"authentication.two-step-verification.audit.identity.verification.elevated-session.successful", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(username)).extraAttribute(AuditAttribute.fromI18nKeys((String)I18N_METHOD_LABEL, (String)method.name()).build()).build();
        this.auditService.audit(event);
    }

    public void logTsvSessionElevationFailure(@Nonnull String username, @Nonnull VerificationMethod method) {
        String actionKey = "authentication.two-step-verification.audit.identity.verification.elevated-session.failed";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.IDENTITY_VERIFICATION.getKey(), (String)"authentication.two-step-verification.audit.identity.verification.elevated-session.failed", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(username)).extraAttribute(AuditAttribute.fromI18nKeys((String)I18N_METHOD_LABEL, (String)method.name()).build()).build();
        this.auditService.audit(event);
    }

    public void logTsvWebSudoVerificationSuccess(@Nonnull UserKey userKey, @Nonnull VerificationMethod method) {
        String actionKey = "authentication.two-step-verification.audit.identity.verification.websudo.successful";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.IDENTITY_VERIFICATION.getKey(), (String)"authentication.two-step-verification.audit.identity.verification.websudo.successful", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(userKey)).extraAttribute(AuditAttribute.fromI18nKeys((String)I18N_METHOD_LABEL, (String)method.name()).build()).build();
        this.auditService.audit(event);
    }

    public void logTsvWebSudoVerificationFailure(@Nonnull UserKey userKey, @Nonnull VerificationMethod method) {
        String actionKey = "authentication.two-step-verification.audit.identity.verification.websudo.failed";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.IDENTITY_VERIFICATION.getKey(), (String)"authentication.two-step-verification.audit.identity.verification.websudo.failed", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(userKey)).extraAttribute(AuditAttribute.fromI18nKeys((String)I18N_METHOD_LABEL, (String)method.name()).build()).build();
        this.auditService.audit(event);
    }

    public void logUserLoginViaLoginFormWithout2SV(@Nonnull UserKey userKey) {
        this.logUserLoginViaLoginFormWithout2SV(userKey, this.enforcementService.isHighRiskAuthorityUser(userKey));
    }

    public void logUserLoginViaLoginFormWithout2SV(@Nonnull UserKey userKey, boolean highRiskAuthorityUser) {
        if (highRiskAuthorityUser) {
            this.publishAuditLogForHighRiskAuthorityUser(userKey);
        }
        this.eventPublisher.publish((Object)new IdentityVerificationAnalyticsEvent(userKey.getStringValue(), highRiskAuthorityUser, VerificationMethod.PASSWORD));
    }

    public void logUserRateLimited(@Nonnull UserRateLimitDTO userRateLimit) {
        String actionKey = "authentication.two-step-verification.audit.identity.verification.rate-limited";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.IDENTITY_VERIFICATION.getKey(), (String)"authentication.two-step-verification.audit.identity.verification.rate-limited", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(new UserKey(userRateLimit.userKey()))).extraAttributes(List.of(AuditAttribute.fromI18nKeys((String)I18N_RATE_LIMIT_FAILURES, (String)String.valueOf(userRateLimit.consecutiveFailures())).build(), AuditAttribute.fromI18nKeys((String)I18N_NEXT_BACKOFF_IN_SECONDS, (String)String.valueOf(userRateLimit.nextBackoffInSeconds())).build(), AuditAttribute.fromI18nKeys((String)I18N_NEXT_ALLOWED_TIME, (String)String.valueOf(this.getNextAllowedDateTime(userRateLimit))).build())).build();
        this.auditService.audit(event);
    }

    public void logUserLoginWithSSO(@Nonnull String username, @Nonnull VerificationMethod ssoMethod) {
        String userKey = this.getUserKey(username);
        this.eventPublisher.publish((Object)new IdentityVerificationAnalyticsEvent(userKey, this.enforcementService.isHighRiskAuthorityUser(new UserKey(userKey)), ssoMethod));
    }

    private String getUserKey(@Nonnull String username) {
        return Optional.ofNullable(this.userManager.getUserProfile(username)).map(UserProfile::getUserKey).map(UserKey::getStringValue).orElse("");
    }

    private void publishAuditLogForHighRiskAuthorityUser(@Nonnull UserKey userKey) {
        String actionKey = "authentication.two-step-verification.audit.identity.verification.admin-without-tsv";
        AuditEvent event = AuditEvent.fromI18nKeys((String)AuthAuditCategory.IDENTITY_VERIFICATION.getKey(), (String)"authentication.two-step-verification.audit.identity.verification.admin-without-tsv", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.SECURITY).affectedObject(this.getUser(userKey)).build();
        this.auditService.audit(event);
    }

    private AuditResource getUser(@Nonnull UserKey userKey) {
        return AuditResource.builder((String)this.getName(userKey), (String)AuthAuditResourceType.USER.getValue()).build();
    }

    private AuditResource getUser(@Nonnull String username) {
        return AuditResource.builder((String)username, (String)AuthAuditResourceType.USER.getValue()).build();
    }

    private String getName(UserKey userKey) {
        return Optional.ofNullable(this.userManager.getUserProfile(userKey)).map(UserProfile::getUsername).orElse(userKey.getStringValue());
    }

    private ZonedDateTime getNextAllowedDateTime(UserRateLimitDTO userRateLimit) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(userRateLimit.nextAllowedTime()), this.timeZoneManager.getDefaultTimeZone().toZoneId());
    }
}

