/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.credentialverification;

import com.atlassian.crowd.integration.Constants;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialValidationNoOpHttpServletResponse;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialVerificationException;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialVerificationService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.CrowdSsoCookieData;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.NewCookie;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCredentialVerificationService
implements CredentialVerificationService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final UserManager userManager;

    public AbstractCredentialVerificationService(UserManager userManager) {
        this.userManager = userManager;
    }

    protected UserKey resolveUserKey(String username) throws CredentialVerificationException {
        UserProfile userProfile = this.userManager.getUserProfile(username);
        if (userProfile == null) {
            throw CredentialVerificationException.userNotFound(username);
        }
        return userProfile.getUserKey();
    }

    protected CrowdSsoCookieData getCrowdTokenCookie(HttpServletRequest request, CredentialValidationNoOpHttpServletResponse response) {
        String token = (String)request.getAttribute(Constants.COOKIE_TOKEN_KEY);
        return response.getCookies().stream().filter(cookie -> Objects.equals(cookie.getValue(), token)).findFirst().map(cookie -> new CrowdSsoCookieData((NewCookie)cookie, this.getSessionAttributes(request))).orElse(null);
    }

    private Map<String, Object> getSessionAttributes(HttpServletRequest request) {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        Enumeration attributeNames = request.getSession(false).getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = request.getSession(false).getAttribute(attributeName);
            attributesMap.put(attributeName, attributeValue);
        }
        return attributesMap;
    }
}

