/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.credentialverification;

import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialValidationNoOpHttpSession;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class CredentialValidationNoOpHttpServletRequest
implements HttpServletRequest {
    public static final String TWOSV_LOGIN_ATTRIBUTE = "com.atlassian.plugins.authentication.2sv.login";
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Multimap<String, String> headers;
    private final String contextPath;
    private final String serverName;
    private final int serverPort;
    private final String remoteAddr;
    private final String remoteHost;
    private final boolean secure;
    private final int remotePort;
    private final String localAddr;
    private final String localName;
    private final int localPort;
    private CredentialValidationNoOpHttpSession session;
    private final List<Cookie> cookies;
    private final ServletContext servletContext;

    public CredentialValidationNoOpHttpServletRequest(HttpServletRequest request) {
        this.contextPath = request.getContextPath();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.remoteAddr = request.getRemoteAddr();
        this.remoteHost = request.getRemoteHost();
        this.remotePort = request.getRemotePort();
        this.localAddr = request.getLocalAddr();
        this.localName = request.getLocalName();
        this.localPort = request.getLocalPort();
        this.secure = request.isSecure();
        this.attributes.put(TWOSV_LOGIN_ATTRIBUTE, true);
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            ImmutableListMultimap.Builder headerMapBuilder = ImmutableListMultimap.builder();
            while (headerNames.hasMoreElements()) {
                String header = (String)headerNames.nextElement();
                headerMapBuilder.putAll((Object)header, Collections.list(request.getHeaders(header)));
            }
            this.headers = headerMapBuilder.build();
        } else {
            this.headers = ImmutableListMultimap.of();
        }
        Cookie[] originalCookies = request.getCookies();
        this.cookies = originalCookies == null ? null : Arrays.stream(request.getCookies()).map(c -> new Cookie(c.getName(), c.getValue())).collect(Collectors.toList());
        this.servletContext = request.getServletContext();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (create && this.session == null) {
            this.session = new CredentialValidationNoOpHttpSession(this.servletContext);
        }
        return this.session;
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() {
        return Collections.emptyList();
    }

    public Part getPart(String name) {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return this.cookies == null ? null : this.cookies.toArray(new Cookie[0]);
    }

    public long getDateHeader(String name) {
        return -1L;
    }

    public String getHeader(String name) {
        return (String)Iterables.getFirst((Iterable)this.headers.get((Object)name), null);
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.headers.get((Object)name));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        Integer maybeParsedHeader = Ints.tryParse((String)Strings.nullToEmpty((String)this.getHeader(name)));
        return maybeParsedHeader == null ? -1 : maybeParsedHeader;
    }

    public String getMethod() {
        return "POST";
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public PushBuilder newPushBuilder() {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return "/";
    }

    public StringBuffer getRequestURL() {
        throw new UnsupportedOperationException();
    }

    public String getServletPath() {
        return "";
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        throw new UnsupportedEncodingException();
    }

    public int getContentLength() {
        return 0;
    }

    public long getContentLengthLong() {
        return 0L;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.emptyEnumeration();
    }

    public String[] getParameterValues(String name) {
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.emptyMap();
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String name, Object o) {
        if (!Objects.equals(name, TWOSV_LOGIN_ATTRIBUTE)) {
            this.attributes.put(name, o);
        }
    }

    public void removeAttribute(String name) {
        if (!Objects.equals(name, TWOSV_LOGIN_ATTRIBUTE)) {
            this.attributes.remove(name);
        }
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Collections.singleton(Locale.getDefault()));
    }

    public boolean isSecure() {
        return this.secure;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public String getRequestId() {
        return "";
    }

    public String getProtocolRequestId() {
        return "";
    }

    public ServletConnection getServletConnection() {
        return null;
    }
}

