/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.credentialverification;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.NewCookie;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class CredentialValidationNoOpHttpServletResponse
implements HttpServletResponse {
    private int status = 200;
    private String characterEncoding = StandardCharsets.UTF_8.name();
    private final Multimap<String, String> headers = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
    private final List<NewCookie> cookies = new ArrayList<NewCookie>();

    public void addCookie(Cookie cookie) {
        this.cookies.add(CredentialValidationNoOpHttpServletResponse.maptoNewCookie(cookie));
        this.addHeader("Set-Cookie", String.format("%s=%s", cookie.getName(), cookie.getValue()));
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey((Object)name);
    }

    public String encodeURL(String url) {
        return null;
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    public void sendError(int sc, String msg) {
        this.setStatus(sc);
    }

    public void sendError(int sc) {
        this.setStatus(sc);
    }

    public void sendRedirect(String location) {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, String.valueOf(date));
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, String.valueOf(date));
    }

    public void setHeader(String name, String value) {
        this.headers.replaceValues((Object)name, Collections.singleton(value));
    }

    public void addHeader(String name, String value) {
        this.headers.get((Object)name).add(value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.replaceValues((Object)name, Collections.singleton(String.valueOf(value)));
    }

    public void addIntHeader(String name, int value) {
        this.headers.get((Object)name).add(String.valueOf(value));
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public int getStatus() {
        return this.status;
    }

    public String getHeader(String name) {
        return (String)Iterables.getFirst((Iterable)this.headers.get((Object)name), null);
    }

    public Collection<String> getHeaders(String name) {
        return List.copyOf(this.headers.get((Object)name));
    }

    public Collection<String> getHeaderNames() {
        return Set.copyOf(this.headers.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public ServletOutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }

    public PrintWriter getWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
    }

    public void setContentLength(int len) {
        this.setHeader("Content-Length", String.valueOf(len));
    }

    public void setContentLengthLong(long len) {
        this.setHeader("Content-Length", String.valueOf(len));
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() {
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void setLocale(Locale loc) {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public List<NewCookie> getCookies() {
        return this.cookies;
    }

    private static NewCookie maptoNewCookie(Cookie servletCookie) {
        if (servletCookie == null) {
            return null;
        }
        return new NewCookie(servletCookie.getName(), servletCookie.getValue(), servletCookie.getPath(), servletCookie.getDomain(), 1, null, servletCookie.getMaxAge(), null, servletCookie.getSecure(), servletCookie.isHttpOnly());
    }
}

