/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.credentialverification;

import com.atlassian.plugins.authentication.tsv.model.LoginResult;

public class CredentialVerificationException
extends Exception {
    private final LoginResult loginResult;

    public CredentialVerificationException(LoginResult loginResult) {
        this.loginResult = loginResult;
    }

    public CredentialVerificationException(String message, LoginResult loginResult) {
        super(message);
        this.loginResult = loginResult;
    }

    public CredentialVerificationException(Throwable e, LoginResult loginResult) {
        super(e);
        this.loginResult = loginResult;
    }

    public static CredentialVerificationException userNotFound(String username) {
        return new CredentialVerificationException(String.format("User %s could not be found", username), LoginResult.USER_DOES_NOT_EXIST);
    }

    public LoginResult getLoginResult() {
        return this.loginResult;
    }
}

