/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.credentialverification;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.plugins.authentication.tsv.model.LoginResult;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.AbstractCredentialVerificationService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialVerificationException;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.SuccessfulCredentialVerificationResult;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;

public class EmbeddedCrowdCredentialVerificationService
extends AbstractCredentialVerificationService {
    private static final String AUTHENTICATION_EXCEPTION = "SPRING_SECURITY_LAST_EXCEPTION";
    private static final String LAST_USERNAME_KEY = "SPRING_SECURITY_LAST_USERNAME";
    protected final CrowdService crowdService;

    public EmbeddedCrowdCredentialVerificationService(CrowdService crowdService, UserManager userManager) {
        super(userManager);
        this.crowdService = crowdService;
    }

    @Override
    @Nonnull
    public SuccessfulCredentialVerificationResult verifyCredentials(HttpServletRequest request, HttpServletResponse response, String username, String password) throws CredentialVerificationException {
        try {
            User user = this.crowdService.authenticate(username, password);
            UserKey userKey = this.resolveUserKey(user.getName());
            return new SuccessfulCredentialVerificationResult((Principal)user, userKey, null);
        }
        catch (FailedAuthenticationException | OperationFailedException e) {
            this.log.debug("Exception thrown by Embedded Crowd when authenticating user {}", (Object)username, (Object)e);
            LoginResult result = LoginResult.AUTHENTICATION_FAILED;
            if (e instanceof ExpiredCredentialException) {
                ExpiredCredentialException exception = (ExpiredCredentialException)e;
                request.getSession().setAttribute(LAST_USERNAME_KEY, (Object)username);
                request.getSession().setAttribute(AUTHENTICATION_EXCEPTION, (Object)exception);
                result = LoginResult.USER_CREDENTIALS_EXPIRED;
            }
            throw new CredentialVerificationException(e, result);
        }
    }
}

