/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.credentialverification;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.plugins.authentication.tsv.model.LoginResult;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialValidationNoOpHttpServletRequest;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialValidationNoOpHttpServletResponse;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialVerificationException;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.EmbeddedCrowdCredentialVerificationService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.SuccessfulCredentialVerificationResult;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.resultextractor.SeraphLoginResultExtractor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfig;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;

public class SeraphCredentialVerificationService
extends EmbeddedCrowdCredentialVerificationService {
    private final boolean fallbackToCrowd = Boolean.getBoolean("atlassian.authentication.seraph.crowd_fallback");
    private final SeraphLoginResultExtractor seraphLoginResultExtractor;

    public SeraphCredentialVerificationService(CrowdService crowdService, UserManager userManager, SeraphLoginResultExtractor seraphLoginResultExtractor) {
        super(crowdService, userManager);
        this.seraphLoginResultExtractor = seraphLoginResultExtractor;
    }

    @Override
    @Nonnull
    public SuccessfulCredentialVerificationResult verifyCredentials(HttpServletRequest request, HttpServletResponse response, String username, String password) throws CredentialVerificationException {
        SecurityConfig securityConfig = (SecurityConfig)request.getServletContext().getAttribute("seraph_config");
        if (securityConfig == null || this.fallbackToCrowd) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Seraph credential validation service delegating to Crowd, Seraph security config: {}, explicit fallback: {}", (Object)(securityConfig == null ? "present" : "absent"), (Object)this.fallbackToCrowd);
            }
            return super.verifyCredentials(request, response, username, password);
        }
        Authenticator authenticator = securityConfig.getAuthenticator();
        try {
            CredentialValidationNoOpHttpServletRequest credentialValidationHttpRequest = new CredentialValidationNoOpHttpServletRequest(request);
            CredentialValidationNoOpHttpServletResponse credentialsCheckResponse = new CredentialValidationNoOpHttpServletResponse();
            LoginResult result = this.verifyCredentialsWithSeraph(request, username, password, authenticator, credentialValidationHttpRequest, credentialsCheckResponse);
            if (result != LoginResult.OK) {
                this.log.debug("Seraph rejected authentication of user {} with result {}", (Object)username, (Object)result);
                throw new CredentialVerificationException("Authentication rejected by Seraph authenticator", result);
            }
            User user = this.crowdService.getUser(username);
            if (user == null) {
                this.log.debug("User {} was not found through Embedded Crowd after Seraph authentication", (Object)username);
                throw CredentialVerificationException.userNotFound(username);
            }
            UserKey userKey = this.resolveUserKey(username);
            return new SuccessfulCredentialVerificationResult((Principal)user, userKey, this.getCrowdTokenCookie(credentialValidationHttpRequest, credentialsCheckResponse));
        }
        catch (AuthenticatorException e) {
            this.log.error("Seraph returned an error when authenticating user {}", (Object)username, (Object)e);
            throw new CredentialVerificationException(e, LoginResult.AUTHENTICATION_FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginResult verifyCredentialsWithSeraph(HttpServletRequest request, String username, String password, Authenticator authenticator, HttpServletRequest credentialValidationHttpRequest, HttpServletResponse credentialsCheckResponse) throws AuthenticatorException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader authenticatorClassLoader = authenticator.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(authenticatorClassLoader);
            boolean success = authenticator.login(credentialValidationHttpRequest, credentialsCheckResponse, username, password, false);
            LoginResult loginResult = this.seraphLoginResultExtractor.extract(success, credentialValidationHttpRequest);
            return loginResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

