/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.enforcement;

import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.tsv.model.EnforcementType;
import com.atlassian.plugins.authentication.tsv.service.enforcement.EnforcementService;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;

public class DefaultEnforcementService
implements EnforcementService {
    protected final UserManager userManager;
    protected final AuthenticationPluginFeatureInternalService authenticationPluginFeatureService;

    public DefaultEnforcementService(UserManager userManager, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService) {
        this.userManager = userManager;
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
    }

    @Override
    public boolean isHighRiskAuthorityUser(UserKey userKey) {
        return this.userManager.isSystemAdmin(userKey);
    }

    @Override
    public boolean isEnforcementRequired(UserKey userKey) {
        EnforcementType enforcementType = this.getEnforcementType();
        return enforcementType == EnforcementType.ALL_USERS || enforcementType == EnforcementType.ADMINS && this.isHighRiskAuthorityUser(userKey);
    }

    @Override
    public EnforcementType getEnforcementType() {
        if (this.authenticationPluginFeatureService.isEnforcementEnabledForAllUsers()) {
            return EnforcementType.ALL_USERS;
        }
        if (this.authenticationPluginFeatureService.isEnforcementEnabledForAdmins()) {
            return EnforcementType.ADMINS;
        }
        return EnforcementType.NONE;
    }
}

