/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.responsebuilder;

import com.atlassian.jira.bc.security.login.LoginProperties;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.plugins.authentication.sso.web.loginpage.JiraContactFormUtil;
import com.atlassian.plugins.authentication.tsv.model.LoginResult;
import com.atlassian.plugins.authentication.tsv.rest.model.CredentialsCheckFailedDTO;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.FailedLoginResponseContext;
import com.atlassian.plugins.authentication.tsv.service.responsebuilder.AbstractAuthenticationFailedResponseBuilder;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;

public class JiraAuthenticationFailedResponseBuilder
extends AbstractAuthenticationFailedResponseBuilder {
    private final JiraContactHelper jiraContactHelper;
    private final I18nHelper i18nHelper;
    private final LoginService loginService;

    public JiraAuthenticationFailedResponseBuilder(I18nResolver i18nResolver, JiraContactHelper jiraContactHelper, I18nHelper i18nHelper, LoginService loginService) {
        super(i18nResolver);
        this.jiraContactHelper = jiraContactHelper;
        this.i18nHelper = i18nHelper;
        this.loginService = loginService;
    }

    @Override
    public Response generateLoginFailedResponse(FailedLoginResponseContext context) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.createCredentialsCheckFailedDTO(context)).build();
    }

    @Nonnull
    private CredentialsCheckFailedDTO createCredentialsCheckFailedDTO(FailedLoginResponseContext context) {
        this.checkLoginResultValid(context.loginResult());
        return switch (context.loginResult()) {
            case LoginResult.AUTHORISATION_FAILED -> {
                LoginProperties loginProperties = this.loginService.getLoginProperties(null, context.request());
                String administratorContactMessage = JiraContactFormUtil.shouldShowAdminContactLink(loginProperties, this.jiraContactHelper) ? this.jiraContactHelper.getAdministratorContactLinkHtml(context.request().getContextPath(), this.i18nHelper) : this.jiraContactHelper.getAdministratorContactMessage(this.i18nHelper);
                yield new CredentialsCheckFailedDTO(this.i18nResolver.getText("login.error.permission", new Serializable[]{administratorContactMessage}), context.captchaRequired(), context.expiredCredentials());
            }
            default -> new CredentialsCheckFailedDTO(this.i18nResolver.getText("authentication.login.failed.invalid-credentials"), context.captchaRequired(), context.expiredCredentials());
        };
    }
}

