/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.session;

import com.atlassian.crowd.service.authentication.CrowdApplicationAuthenticationService;
import com.atlassian.plugins.authentication.sso.web.usercontext.AuthenticationFailedException;
import com.atlassian.plugins.authentication.tsv.service.session.AuthenticatedSessionCreator;
import com.atlassian.plugins.authentication.tsv.service.session.SessionService;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;

public class CrowdAuthenticatedSessionCreator
implements AuthenticatedSessionCreator {
    private final CrowdApplicationAuthenticationService crowdApplicationAuthenticationService;

    public CrowdAuthenticatedSessionCreator(CrowdApplicationAuthenticationService crowdApplicationAuthenticationService) {
        this.crowdApplicationAuthenticationService = crowdApplicationAuthenticationService;
    }

    @Override
    public void createSession(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Principal user, @Nonnull SessionService.AuthenticationType authenticationType) {
        try {
            this.crowdApplicationAuthenticationService.authenticate(request, response, user.getName());
        }
        catch (Exception e) {
            throw new AuthenticationFailedException("Failed to authenticate user", e);
        }
    }
}

