/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.session;

import com.atlassian.plugins.authentication.tsv.service.session.AuthenticatedSessionCreator;
import com.atlassian.plugins.authentication.tsv.service.session.SessionService;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.security.Principal;

public class EmbeddedCrowdAuthenticatedSessionCreator
implements AuthenticatedSessionCreator {
    private final AuthenticationListener authenticationListener;
    private final I18nResolver i18nResolver;

    public EmbeddedCrowdAuthenticatedSessionCreator(AuthenticationListener authenticationListener, I18nResolver i18nResolver) {
        this.authenticationListener = authenticationListener;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public void createSession(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Principal user, @Nonnull SessionService.AuthenticationType authenticationType) {
        this.authenticationListener.authenticationSuccess((Authenticator.Result)new Authenticator.Result.Success(this.i18nResolver.createMessage(this.i18nResolver.getText(EmbeddedCrowdAuthenticatedSessionCreator.getKey(authenticationType)), new Serializable[]{user.getName()}), user), request, response);
    }

    @Nonnull
    private static String getKey(SessionService.AuthenticationType authenticationType) {
        return switch (authenticationType) {
            default -> throw new MatchException(null, null);
            case SessionService.AuthenticationType.LOGIN_FORM -> "authentication.login.success";
            case SessionService.AuthenticationType.SAML -> "saml.authentication.successful";
            case SessionService.AuthenticationType.OIDC -> "oidc.authentication.successful";
        };
    }
}

