/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.session;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.integration.Constants;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthAuditService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.VerificationMethod;
import com.atlassian.plugins.authentication.sso.web.PostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.SessionDataService;
import com.atlassian.plugins.authentication.sso.web.usercontext.rememberme.RememberMeCookieHandler;
import com.atlassian.plugins.authentication.tsv.exception.InactiveUserAuthenticationException;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.CrowdSsoCookieData;
import com.atlassian.plugins.authentication.tsv.service.session.AuthenticatedSessionCreator;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.NewCookie;
import java.security.Principal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionService {
    private static final Logger log = LoggerFactory.getLogger(SessionService.class);
    private final SessionDataService sessionDataService;
    private final AuthenticatedSessionCreator authenticatedSessionCreator;
    private final I18nResolver i18nResolver;
    private final PostAuthenticationProcessor postAuthenticationProcessor;
    private final CrowdService crowdService;
    private final UserManager userManager;
    private final RememberMeCookieHandler rememberMeCookieHandler;
    private final AuthAuditService authAuditService;

    public SessionService(SessionDataService sessionDataService, AuthenticatedSessionCreator authenticatedSessionCreator, I18nResolver i18nResolver, PostAuthenticationProcessor postAuthenticationProcessor, CrowdService crowdService, UserManager userManager, RememberMeCookieHandler rememberMeCookieHandler, AuthAuditService authAuditService) {
        this.sessionDataService = sessionDataService;
        this.authenticatedSessionCreator = authenticatedSessionCreator;
        this.i18nResolver = i18nResolver;
        this.postAuthenticationProcessor = postAuthenticationProcessor;
        this.crowdService = crowdService;
        this.userManager = userManager;
        this.rememberMeCookieHandler = rememberMeCookieHandler;
        this.authAuditService = authAuditService;
    }

    public void createNewSession(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull String userKey, boolean rememberMe, AuthenticationType authenticationType, CrowdSsoCookieData crowdSsoCookieData) {
        UserProfile userProfile = Objects.requireNonNull(this.userManager.getUserProfile(new UserKey(userKey)));
        User user = this.crowdService.getUser(userProfile.getUsername());
        this.createNewSession(request, response, (Principal)user, rememberMe, authenticationType, crowdSsoCookieData);
    }

    public void createNewSession(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Principal user, boolean rememberMe, AuthenticationType authenticationType) {
        this.createNewSession(request, response, user, rememberMe, authenticationType, null);
    }

    public void createNewSession(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Principal user, boolean rememberMe, AuthenticationType authenticationType, CrowdSsoCookieData crowdSsoCookieData) {
        User crowdUser;
        if (user instanceof User && !(crowdUser = (User)user).isActive()) {
            log.debug("Did not create new authenticated session for user: {} because the user is not active.", (Object)crowdUser.getName());
            throw new InactiveUserAuthenticationException("User: " + crowdUser.getName() + " is not active.");
        }
        this.sessionDataService.requireNewSession(request);
        switch (authenticationType.ordinal()) {
            case 0: {
                this.sessionDataService.setUserLoggedInWith2sv(request);
                break;
            }
            case 1: {
                this.sessionDataService.setUserLoggedInWithSso(request);
                this.authAuditService.logUserLoginWithSSO(user.getName(), VerificationMethod.SSO_SAML);
                break;
            }
            case 2: {
                this.sessionDataService.setUserLoggedInWithSso(request);
                this.authAuditService.logUserLoginWithSSO(user.getName(), VerificationMethod.SSO_OIDC);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)authenticationType));
            }
        }
        this.authenticatedSessionCreator.createSession(request, response, user, authenticationType);
        this.postAuthenticationProcessor.productSpecificWorkarounds(request, user.getName(), authenticationType);
        log.debug("Create new authenticated session for user: {}", (Object)user.getName());
        if (rememberMe) {
            this.rememberMeCookieHandler.refreshRememberMeCookie(request, response, user);
            log.debug("Refreshed 'remember me' cookie for {}", (Object)user.getName());
        }
        if (crowdSsoCookieData != null && request.getAttribute("com.atlassian.crowd.integration.http.HttpAuthenticator.REQUEST_SSO_COOKIE_COMMITTED") == null) {
            NewCookie crowdSsoCookie = crowdSsoCookieData.crowdSsoCookie();
            request.setAttribute(Constants.COOKIE_TOKEN_KEY, (Object)crowdSsoCookie.getValue());
            crowdSsoCookieData.sessionAttributes().keySet().stream().forEach(sessionAttribute -> request.getSession(false).setAttribute(sessionAttribute, crowdSsoCookieData.sessionAttributes().get(sessionAttribute)));
            response.addCookie(SessionService.mapToCookie(crowdSsoCookie));
            request.setAttribute("com.atlassian.crowd.integration.http.HttpAuthenticator.REQUEST_SSO_COOKIE_COMMITTED", (Object)Boolean.TRUE);
            log.debug("CrowdSSO cookie set for {}", (Object)user.getName());
        }
    }

    @Nonnull
    private static String getKey(AuthenticationType authenticationType) {
        return switch (authenticationType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "authentication.login.success";
            case 1 -> "saml.authentication.successful";
            case 2 -> "oidc.authentication.successful";
        };
    }

    public static Cookie mapToCookie(NewCookie newCookie) {
        if (newCookie == null) {
            return null;
        }
        Cookie cookie = new Cookie(newCookie.getName(), newCookie.getValue());
        if (newCookie.getPath() != null) {
            cookie.setPath(newCookie.getPath());
        }
        if (newCookie.getDomain() != null) {
            cookie.setDomain(newCookie.getDomain());
        }
        if (newCookie.getMaxAge() >= 0) {
            cookie.setMaxAge(newCookie.getMaxAge());
        }
        cookie.setSecure(newCookie.isSecure());
        cookie.setHttpOnly(newCookie.isHttpOnly());
        return cookie;
    }

    public static enum AuthenticationType {
        LOGIN_FORM,
        SAML,
        OIDC;

    }
}

