/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.spring;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.audit.api.AuditService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.onetime.core.TOTPGenerator;
import com.atlassian.onetime.service.DefaultTOTPService;
import com.atlassian.onetime.service.TOTPConfiguration;
import com.atlassian.onetime.service.TOTPService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthAuditService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthenticationPluginFeatureService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.RecoveryCodeService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.TotpService;
import com.atlassian.plugins.authentication.api.tsv.service.RateLimitingService;
import com.atlassian.plugins.authentication.api.tsv.service.RemoveOnlyEnrollmentService;
import com.atlassian.plugins.authentication.api.tsv.service.SeenTotpCodesService;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.common.spring.CommonImportsConfiguration;
import com.atlassian.plugins.authentication.encryption.EncryptionService;
import com.atlassian.plugins.authentication.sso.spring.JvmBeansConfiguration;
import com.atlassian.plugins.authentication.sso.spring.SsoConfiguration;
import com.atlassian.plugins.authentication.sso.web.CookieService;
import com.atlassian.plugins.authentication.sso.web.PostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.SessionDataService;
import com.atlassian.plugins.authentication.sso.web.usercontext.rememberme.RememberMeCookieHandler;
import com.atlassian.plugins.authentication.tsv.db.TotpCodesDao;
import com.atlassian.plugins.authentication.tsv.db.TotpUserEnrollmentDao;
import com.atlassian.plugins.authentication.tsv.job.EnrollmentCleanupJob;
import com.atlassian.plugins.authentication.tsv.rest.filters.ratelimit.RateLimit;
import com.atlassian.plugins.authentication.tsv.rest.filters.ratelimit.RateLimitMethodInterceptor;
import com.atlassian.plugins.authentication.tsv.rest.filters.ratelimit.RateLimitRequestFilter;
import com.atlassian.plugins.authentication.tsv.rest.filters.ratelimit.RateLimitResponseFilter;
import com.atlassian.plugins.authentication.tsv.service.DefaultRateLimitingService;
import com.atlassian.plugins.authentication.tsv.service.DefaultRecoveryCodeService;
import com.atlassian.plugins.authentication.tsv.service.DefaultSeenTotpCodesService;
import com.atlassian.plugins.authentication.tsv.service.DefaultTotpService;
import com.atlassian.plugins.authentication.tsv.service.ElevatedSessionService;
import com.atlassian.plugins.authentication.tsv.service.EnrollmentCleanupService;
import com.atlassian.plugins.authentication.tsv.service.EnrollmentService;
import com.atlassian.plugins.authentication.tsv.service.InternalRecoveryCodeService;
import com.atlassian.plugins.authentication.tsv.service.InternalRemoveOnlyEnrollmentService;
import com.atlassian.plugins.authentication.tsv.service.InternalTotpService;
import com.atlassian.plugins.authentication.tsv.service.RandomSecretGenerator;
import com.atlassian.plugins.authentication.tsv.service.RecoveryCodeGenerator;
import com.atlassian.plugins.authentication.tsv.service.SecureRandomProvider;
import com.atlassian.plugins.authentication.tsv.service.SsoManagementStatusService;
import com.atlassian.plugins.authentication.tsv.service.StatusService;
import com.atlassian.plugins.authentication.tsv.service.TotpConversationService;
import com.atlassian.plugins.authentication.tsv.service.TotpIssuerService;
import com.atlassian.plugins.authentication.tsv.service.TotpLoginService;
import com.atlassian.plugins.authentication.tsv.service.audit.DefaultAuthAuditService;
import com.atlassian.plugins.authentication.tsv.service.enforcement.EnforcementService;
import com.atlassian.plugins.authentication.tsv.service.session.AuthenticatedSessionCreator;
import com.atlassian.plugins.authentication.tsv.service.session.SessionService;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.scheduler.SchedulerService;
import java.time.Clock;
import org.aopalliance.aop.Advice;
import org.osgi.framework.ServiceRegistration;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.autoproxy.AbstractBeanFactoryAwareAdvisingPostProcessor;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CommonImportsConfiguration.class, JvmBeansConfiguration.class, SsoConfiguration.class})
public class TwoStepVerificationConfiguration {
    @Bean
    public AuthAuditService tsvAuditService(AuditService auditService, UserManager userManager, TimeZoneManager timeZoneManager, EventPublisher eventPublisher, EnforcementService enforcementService) {
        return new DefaultAuthAuditService(auditService, userManager, timeZoneManager, eventPublisher, enforcementService);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportAuthAuditService(AuthAuditService tsvAuditService) {
        return OsgiServices.exportOsgiService((Object)tsvAuditService, (ExportOptions)ExportOptions.as(AuthAuditService.class, (Class[])new Class[0]));
    }

    @Bean
    public ElevatedSessionService elevatedSessionService(Clock clock, CookieService cookieService, CrowdService crowdService, UserManager userManager, I18nResolver i18nResolver, InternalRecoveryCodeService recoveryCodeService, EnrollmentService enrollmentService, InternalTotpService totpService, AuthAuditService authAuditService) {
        return new ElevatedSessionService(clock, cookieService, crowdService, userManager, i18nResolver, recoveryCodeService, enrollmentService, totpService, authAuditService);
    }

    @Bean
    public InternalRecoveryCodeService recoveryCodeConsumer(TotpUserEnrollmentDao totpUserEnrollmentDao, RecoveryCodeGenerator recoveryCodeGenerator, AuthAuditService authAuditService) {
        return new DefaultRecoveryCodeService(totpUserEnrollmentDao, recoveryCodeGenerator, authAuditService);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportRecoveryCodeService(InternalRecoveryCodeService internalRecoveryCodeService) {
        return OsgiServices.exportOsgiService((Object)internalRecoveryCodeService, (ExportOptions)ExportOptions.as(RecoveryCodeService.class, (Class[])new Class[0]));
    }

    @Bean
    public TotpUserEnrollmentDao totpUserEnrollmentDao(ActiveObjects activeObjects, TimeZoneManager timeZoneManager, Clock clock) {
        return new TotpUserEnrollmentDao(activeObjects, timeZoneManager, clock);
    }

    @Bean
    public StatusService statusService(EnforcementService enforcementService, TotpUserEnrollmentDao totpUserEnrollmentDao) {
        return new StatusService(enforcementService, totpUserEnrollmentDao);
    }

    @Bean
    public SsoManagementStatusService ssoManagementStatusService(CrowdService crowdService) {
        return new SsoManagementStatusService(crowdService);
    }

    @Bean
    public TotpConversationService totpConversationService() {
        return new TotpConversationService();
    }

    @Bean
    public SecureRandomProvider secureRandomProvider() {
        return new SecureRandomProvider();
    }

    @Bean
    public RandomSecretGenerator randomSecretGenerator(SecureRandomProvider secureRandomProvider) {
        return new RandomSecretGenerator(secureRandomProvider);
    }

    @Bean
    public RecoveryCodeGenerator recoveryCodeGenerator(SecureRandomProvider secureRandomProvider) {
        return new RecoveryCodeGenerator(secureRandomProvider);
    }

    @Bean
    public TOTPService oneTimeTotpService() {
        TOTPConfiguration totpConfiguration = new TOTPConfiguration(1, 1);
        TOTPGenerator totpGenerator = new TOTPGenerator();
        return new DefaultTOTPService(totpGenerator, totpConfiguration);
    }

    @Bean
    public SessionService sessionService(SessionDataService sessionDataService, AuthenticatedSessionCreator authenticatedSessionCreator, I18nResolver i18nResolver, PostAuthenticationProcessor postAuthenticationProcessor, CrowdService crowdService, UserManager userManager, RememberMeCookieHandler rememberMeCookieHandler, AuthAuditService authAuditService) {
        return new SessionService(sessionDataService, authenticatedSessionCreator, i18nResolver, postAuthenticationProcessor, crowdService, userManager, rememberMeCookieHandler, authAuditService);
    }

    @Bean
    public EnrollmentService enrollmentService(TotpConversationService totpConversationService, RecoveryCodeGenerator recoveryCodeGenerator, RandomSecretGenerator randomSecretGenerator, TotpUserEnrollmentDao totpUserEnrollmentDao, I18nResolver i18nResolver, InternalTotpService totpService, UserManager userManager, EncryptionService encryptionService, AuthAuditService authAuditService) {
        return new EnrollmentService(totpConversationService, recoveryCodeGenerator, randomSecretGenerator, totpUserEnrollmentDao, i18nResolver, totpService, userManager, encryptionService, authAuditService);
    }

    @Bean
    public DefaultTotpService totpService(TotpIssuerService totpIssuerService, I18nResolver i18nResolver, TotpUserEnrollmentDao totpUserEnrollmentDao, TOTPService oneTimetotpService, EncryptionService encryptionService, SeenTotpCodesService seenTotpCodesService) {
        return new DefaultTotpService(totpIssuerService, i18nResolver, totpUserEnrollmentDao, oneTimetotpService, encryptionService, seenTotpCodesService);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportInternalTotpService(InternalTotpService totpService) {
        return OsgiServices.exportOsgiService((Object)totpService, (ExportOptions)ExportOptions.as(TotpService.class, (Class[])new Class[0]));
    }

    @Bean
    public TotpLoginService totpLoginService(InternalTotpService totpService, TotpConversationService totpConversationService, I18nResolver i18nResolver, SessionService sessionService, UserManager userManager, AuthAuditService authAuditService) {
        return new TotpLoginService(totpService, totpConversationService, i18nResolver, sessionService, userManager, authAuditService);
    }

    @Bean
    public SeenTotpCodesService seenTotpCodesService(TotpCodesDao totpCodesDao, SchedulerService schedulerService) {
        return new DefaultSeenTotpCodesService(totpCodesDao, schedulerService);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportSeenTotpCodesService(SeenTotpCodesService seenTotpCodesService) {
        return OsgiServices.exportOsgiService((Object)seenTotpCodesService, (ExportOptions)ExportOptions.as(SeenTotpCodesService.class, (Class[])new Class[0]));
    }

    @Bean
    public DefaultRateLimitingService rateLimitingService(AuthAuditService authAuditService) {
        return new DefaultRateLimitingService(authAuditService);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportRateLimitingService(DefaultRateLimitingService rateLimitingService) {
        return OsgiServices.exportOsgiService((Object)rateLimitingService, (ExportOptions)ExportOptions.as(RateLimitingService.class, (Class[])new Class[0]));
    }

    @Bean
    public RateLimitRequestFilter rateLimitRequestFilter(DefaultRateLimitingService rateLimitingService) {
        return new RateLimitRequestFilter(rateLimitingService);
    }

    @Bean
    public RateLimitResponseFilter rateLimitResponseFilter(DefaultRateLimitingService rateLimitingService) {
        return new RateLimitResponseFilter(rateLimitingService);
    }

    @Bean
    public RateLimitMethodInterceptor rateLimitMethodInterceptor(RateLimitRequestFilter rateLimitRequestFilter, RateLimitResponseFilter rateLimitResponseFilter, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService, I18nResolver i18nResolver, UserManager userManager) {
        return new RateLimitMethodInterceptor(rateLimitRequestFilter, rateLimitResponseFilter, authenticationPluginFeatureService, i18nResolver, userManager);
    }

    @Bean
    public DefaultBeanFactoryPointcutAdvisor rateLimitAdvisor(RateLimitMethodInterceptor rateLimitMethodInterceptor) {
        DefaultBeanFactoryPointcutAdvisor advisor = new DefaultBeanFactoryPointcutAdvisor();
        advisor.setPointcut((Pointcut)AnnotationMatchingPointcut.forMethodAnnotation(RateLimit.class));
        advisor.setAdvice((Advice)rateLimitMethodInterceptor);
        return advisor;
    }

    @Bean
    public BeanPostProcessor advisingPostProcessor(final DefaultBeanFactoryPointcutAdvisor rateLimitAdvisor) {
        return new AbstractBeanFactoryAwareAdvisingPostProcessor(){

            public void setBeanFactory(BeanFactory beanFactory) {
                super.setBeanFactory(beanFactory);
                this.advisor = rateLimitAdvisor;
            }
        };
    }

    @Bean
    public EnrollmentCleanupJob enrollmentCleanupJob(SchedulerService schedulerService, EnrollmentCleanupService enrollmentCleanupService) {
        return new EnrollmentCleanupJob(schedulerService, enrollmentCleanupService);
    }

    @Bean
    public RemoveOnlyEnrollmentService removeOnlyEnrollmentService(TotpUserEnrollmentDao totpUserEnrollmentDao, UserManager userManager) {
        return new InternalRemoveOnlyEnrollmentService(totpUserEnrollmentDao, userManager);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportRemoveOnlyEnrollmentService(RemoveOnlyEnrollmentService removeOnlyEnrollmentService) {
        return OsgiServices.exportOsgiService((Object)removeOnlyEnrollmentService, (ExportOptions)ExportOptions.as(RemoveOnlyEnrollmentService.class, (Class[])new Class[0]));
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportAuthenticationPluginFeatureService(AuthenticationPluginFeatureService authenticationPluginFeatureInternalService) {
        return OsgiServices.exportOsgiService((Object)authenticationPluginFeatureInternalService, (ExportOptions)ExportOptions.as(AuthenticationPluginFeatureService.class, (Class[])new Class[0]));
    }
}

