/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.ui;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;

public abstract class AbstractManageTwoStepVerificationServlet
extends HttpServlet {
    @VisibleForTesting
    protected static final String TEMPLATE_NAME = "AuthenticationPlugin.ManageTwoStepVerification.page";
    private static final String MODULE_KEY = "com.atlassian.plugins.authentication.atlassian-authentication-plugin:two-step-verification-soy-template";
    private static final String TEXT_HTML_CHARSET_UTF_8 = "text/html;charset=UTF-8";
    private final AuthenticationPluginFeatureInternalService authenticationPluginFeatureService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public AbstractManageTwoStepVerificationServlet(AuthenticationPluginFeatureInternalService authenticationPluginFeatureService, SoyTemplateRenderer soyTemplateRenderer) {
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (!this.isTwoStepVerificationAvailable()) {
            resp.sendError(404);
            return;
        }
        try {
            resp.setContentType(TEXT_HTML_CHARSET_UTF_8);
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), MODULE_KEY, TEMPLATE_NAME, Collections.emptyMap());
        }
        catch (SoyException soyException) {
            this.handleSoyError(soyException);
        }
    }

    private void handleSoyError(SoyException e) throws IOException, ServletException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new ServletException((Throwable)e);
    }

    private boolean isTwoStepVerificationAvailable() {
        return !this.authenticationPluginFeatureService.isLegacyModeEnabled();
    }
}

