/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.websudo.internal.service;

import com.atlassian.plugins.authentication.api.tsv.websudo.internal.TsvEnrollmentStatus;
import com.atlassian.plugins.authentication.api.tsv.websudo.internal.service.TsvWebSudoService;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.tsv.service.EnrollmentService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsvWebSudoServiceImpl
implements TsvWebSudoService {
    private static final Logger log = LoggerFactory.getLogger(TsvWebSudoServiceImpl.class);
    private final EnrollmentService enrollmentService;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final AuthenticationPluginFeatureInternalService authenticationPluginFeatureService;
    public static final String WEBSUDO_TSV_URL = "/plugins/servlet/atlauth-2svwebsudo";
    public static final String NEXT_URL_PARAMETER = "nextUrl";

    public TsvWebSudoServiceImpl(EnrollmentService enrollmentService, UserManager userManager, I18nResolver i18nResolver, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService) {
        this.enrollmentService = enrollmentService;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
    }

    public TsvEnrollmentStatus getEnrollmentStatus() {
        if (this.authenticationPluginFeatureService.isLegacyModeEnabled()) {
            this.logLegacyMode();
            return TsvEnrollmentStatus.NOT_ENROLLED;
        }
        if (this.authenticationPluginFeatureService.isTsvWebsudoDisabled()) {
            this.logTsvWebsudoDisabled();
            return TsvEnrollmentStatus.NOT_ENROLLED;
        }
        return this.getTsvEnrollmentStatusInternal(this.userManager.getRemoteUserKey());
    }

    public TsvEnrollmentStatus getEnrollmentStatus(UserKey userKey) {
        if (this.authenticationPluginFeatureService.isLegacyModeEnabled()) {
            this.logLegacyMode();
            return TsvEnrollmentStatus.NOT_ENROLLED;
        }
        if (this.authenticationPluginFeatureService.isTsvWebsudoDisabled()) {
            this.logTsvWebsudoDisabled();
            return TsvEnrollmentStatus.NOT_ENROLLED;
        }
        return this.getTsvEnrollmentStatusInternal(userKey);
    }

    private TsvEnrollmentStatus getTsvEnrollmentStatusInternal(UserKey userKey) {
        return Optional.ofNullable(userKey).map(UserKey::getStringValue).map(this::getStatus).orElseThrow(() -> new IllegalStateException(this.i18nResolver.getText("authentication.two-step-verification.unauthenticated.error.message")));
    }

    public String getTsvRedirectURL(String nextUrl) {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)WEBSUDO_TSV_URL);
        return (nextUrl != null ? uriBuilder.queryParam(NEXT_URL_PARAMETER, new Object[]{nextUrl}) : uriBuilder).build(new Object[0]).toString();
    }

    private TsvEnrollmentStatus getStatus(String userKey) {
        return this.enrollmentService.isAlreadyEnrolled(userKey) ? TsvEnrollmentStatus.ENROLLED : TsvEnrollmentStatus.NOT_ENROLLED;
    }

    private void logLegacyMode() {
        log.debug("Returning NOT_ENROLLED status as legacy mode is enabled");
    }

    private void logTsvWebsudoDisabled() {
        log.debug("Returning NOT_ENROLLED status as 2SV Websudo is disabled");
    }
}

