/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.websudo.spring;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.api.tsv.websudo.internal.service.TsvWebSudoService;
import com.atlassian.plugins.authentication.common.analytics.WebsudoAnalyticsEventPublisher;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.common.spring.CommonImportsConfiguration;
import com.atlassian.plugins.authentication.tsv.service.EnrollmentService;
import com.atlassian.plugins.authentication.tsv.websudo.internal.service.TsvWebSudoServiceImpl;
import com.atlassian.plugins.authentication.websudo.web.data.WebsudoDataProvider;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BitbucketOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Conditional(value={BitbucketOnly.class})
@Import(value={CommonImportsConfiguration.class})
public class WebsudoConfiguration {
    @Bean
    public WebsudoDataProvider websudoDataProvider(ApplicationProperties applicationProperties) {
        return new WebsudoDataProvider(applicationProperties);
    }

    @Bean
    public TsvWebSudoService webSudoService(EnrollmentService enrollmentService, UserManager userManager, I18nResolver i18nResolve, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService) {
        return new TsvWebSudoServiceImpl(enrollmentService, userManager, i18nResolve, authenticationPluginFeatureService);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportTsvWebSudoService(TsvWebSudoService tsvWebSudoService) {
        return OsgiServices.exportOsgiService((Object)tsvWebSudoService, (ExportOptions)ExportOptions.as(TsvWebSudoService.class, (Class[])new Class[0]));
    }

    @Bean
    public WebsudoAnalyticsEventPublisher websudoAnalyticsEventPublisher(EventPublisher eventPublisher, AuthenticationPluginFeatureInternalService authenticationPluginFeatureInternalService) {
        return new WebsudoAnalyticsEventPublisher(eventPublisher, authenticationPluginFeatureInternalService);
    }
}

