/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.ActiveObjectsUpgradeSubtask;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActiveObjectsCompositeUpgradeTask
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractActiveObjectsCompositeUpgradeTask.class);
    private final List<ActiveObjectsUpgradeSubtask> subtasks;
    private final int toModelVersion;

    protected AbstractActiveObjectsCompositeUpgradeTask(int toModelVersion, ActiveObjectsUpgradeSubtask ... subtasks) {
        this.subtasks = Arrays.asList(Objects.requireNonNull(subtasks, "subtasks"));
        this.toModelVersion = toModelVersion;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)String.valueOf(this.toModelVersion));
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        int fromModelVersion = this.toModelVersion - 1;
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)String.valueOf(fromModelVersion))), (Object)String.format("This task can only upgrade from version %d to %d", fromModelVersion, this.toModelVersion));
        ao.executeInTransaction(() -> {
            for (ActiveObjectsUpgradeSubtask subtask : this.subtasks) {
                log.debug("Running upgrade subtask {}", (Object)subtask.getName());
                subtask.upgrade(ao);
            }
            return null;
        });
    }
}

