/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public abstract class AbstractAoDao {
    protected final ActiveObjects ao;

    public AbstractAoDao(ActiveObjects ao) {
        this.ao = Objects.requireNonNull(ao, "ao");
    }

    protected <K, T extends RawEntity<K>> Page<T> pageQuery(Class<T> type, Query query, PageRequest pageRequest) {
        query = AoUtils.restrict(query, pageRequest);
        return AbstractAoDao.createPage(pageRequest, this.ao.find(type, query));
    }

    protected String quoteColumnName(String value) {
        if (this.ao.moduleMetaData().getDatabaseType() == DatabaseType.POSTGRESQL) {
            return "\"" + value + "\"";
        }
        return value;
    }

    @SafeVarargs
    private static <T> Page<T> createPage(PageRequest pageRequest, T ... entities) {
        return PageUtils.createPage((Iterable)ImmutableList.copyOf((Object[])entities), (PageRequest)pageRequest);
    }
}

