/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.ActiveObjectsUpgradeSubtask;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.server.StorageService;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.java.ao.DatabaseProvider;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractTruncateColumnSubtask<T extends RawEntity>
implements ActiveObjectsUpgradeSubtask {
    public static final String DUMP_FILE_SUFFIX = "-original-data.csv";
    private static final Logger log = LoggerFactory.getLogger(AbstractTruncateColumnSubtask.class);
    private static final int PAGE_SIZE = 500;
    private final Pattern aoTableNamePattern;
    private final Path sharedHomeDir;
    private final String tableName;
    private final int truncateLength;

    protected AbstractTruncateColumnSubtask(StorageService storageService, String tableName, int truncateLength) {
        this(storageService.getSharedHomeDir(), tableName, truncateLength);
    }

    private AbstractTruncateColumnSubtask(Path sharedHomeDir, String tableName, int truncateLength) {
        this.sharedHomeDir = sharedHomeDir;
        this.tableName = tableName;
        this.truncateLength = truncateLength;
        this.aoTableNamePattern = Pattern.compile("^AO_[A-Z0-9]{6}_" + Pattern.quote(tableName) + "$", 2);
    }

    @Override
    public String getName() {
        return "truncate-" + this.tableName + "-to-" + this.truncateLength;
    }

    @Override
    public void upgrade(ActiveObjects ao) {
        if (!this.upgradingTableExists(ao)) {
            return;
        }
        Path csvDumpFile = this.sharedHomeDir.resolve(this.tableName + DUMP_FILE_SUFFIX);
        long truncatedRowsNumber = 0L;
        try (CsvDumpWriter csvDumpWriter = new CsvDumpWriter(csvDumpFile, this.getColumnNames());){
            List<T> rows;
            do {
                rows = this.selectRowsToProcess(ao, 500);
                for (RawEntity row : rows) {
                    csvDumpWriter.accept(this.getRowValues(row));
                    this.truncateRowData(row);
                    row.save();
                }
                truncatedRowsNumber += (long)rows.size();
            } while (rows.size() == 500);
        }
        catch (UncheckedIOException e) {
            log.error("Failed to truncate data in table {} during upgrade process", (Object)this.tableName, (Object)e.getCause());
            throw e;
        }
        if (truncatedRowsNumber > 0L) {
            log.warn("Data has been truncated in table {}, number of rows affected: {}. The original data was saved to file '{}'. For more information, see https://go.atlassian.com/bitbucketserverdatatruncation", new Object[]{this.tableName, truncatedRowsNumber, csvDumpFile});
        }
    }

    protected String columnLengthViolatesLimitClause(String columnName, ActiveObjects ao) {
        return String.format("%s(%s) > %d", AoUtils.lengthFunction(ao), AoUtils.quote(ao, columnName), this.truncateLength);
    }

    protected abstract List<String> getColumnNames();

    protected abstract List<String> getRowValues(T var1);

    protected abstract List<T> selectRowsToProcess(ActiveObjects var1, int var2);

    protected abstract void truncateRowData(T var1);

    protected String truncateLongValue(String value) {
        return value.substring(0, Math.min(this.truncateLength, value.length()));
    }

    private boolean upgradingTableExists(ActiveObjects ao) {
        try {
            DatabaseProvider provider = this.getEntityManager(ao).getProvider();
            return this.doesAoTableExist(provider);
        }
        catch (SQLException e) {
            log.error("Upgrade task for table [{}] failed: Unable to verify whether the table in question exists in the database. For more information, see https://go.atlassian.com/bitbucketserverdatatruncation", (Object)this.tableName, (Object)e);
            throw new IllegalStateException("An error occurred while determining whether the table [" + this.tableName + "] exists", e);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean doesAoTableExist(DatabaseProvider provider) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private EntityManager getEntityManager(ActiveObjects ao) {
        Field entityManagerField = ReflectionUtils.findField((Class)ao.getClass(), (String)"entityManager");
        if (entityManagerField == null) {
            throw new IllegalStateException(ao.getClass().getSimpleName() + " does not have an 'entityManager' field");
        }
        ReflectionUtils.makeAccessible((Field)entityManagerField);
        EntityManager entityManager = (EntityManager)ReflectionUtils.getField((Field)entityManagerField, (Object)ao);
        if (entityManager == null) {
            throw new IllegalStateException("No EntityManager is set on " + ao.getClass().getSimpleName());
        }
        return entityManager;
    }

    private static class CsvDumpWriter
    implements Consumer<List<String>>,
    Closeable {
        private final List<String> columnNames;
        private final Path outputFile;
        private Writer writer;

        public CsvDumpWriter(Path outputFile, List<String> columnNames) {
            this.columnNames = columnNames;
            this.outputFile = outputFile;
        }

        @Override
        public void accept(List<String> values) {
            try {
                this.getWriter().write(this.getCsvRow(values));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to backup data to " + String.valueOf(this.outputFile.toAbsolutePath()), e);
            }
        }

        @Override
        public void close() {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to close dump file " + String.valueOf(this.outputFile.toAbsolutePath()), e);
                }
            }
        }

        private String getCsvRow(List<String> values) {
            return values.stream().collect(Collectors.joining(",", "", "\n"));
        }

        private Writer getWriter() throws IOException {
            if (this.writer == null) {
                this.writer = Files.newBufferedWriter(this.outputFile, new OpenOption[0]);
                this.writer.write(this.getCsvRow(this.columnNames));
            }
            return this.writer;
        }
    }
}

