/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.base.Joiner;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import net.java.ao.Query;

public class AoUtils {
    private AoUtils() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " cannot be initialised");
    }

    public static String lengthFunction(@Nonnull ActiveObjects ao) {
        if (Objects.requireNonNull(ao, "ao").moduleMetaData().getDatabaseType() == DatabaseType.MS_SQL) {
            return "LEN";
        }
        return "LENGTH";
    }

    public static Query newQuery(String ... fields) {
        return fields.length > 0 ? Query.select((String)Joiner.on((char)',').join((Object[])fields)) : Query.select();
    }

    public static String quote(@Nonnull ActiveObjects ao, @Nonnull String value) {
        if (Objects.requireNonNull(ao, "ao").moduleMetaData().getDatabaseType() == DatabaseType.POSTGRESQL) {
            return "\"" + Objects.requireNonNull(value, "value") + "\"";
        }
        return value;
    }

    public static Query restrict(Query query, PageRequest pageRequest) {
        return query.offset(pageRequest.getStart()).limit(pageRequest.getLimit() + 1);
    }
}

