/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.xcode;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.content.AbstractContentTreeCallback;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.internal.xcode.XcodeEnableTrigger;
import com.atlassian.bitbucket.internal.xcode.XcodeManager;
import com.atlassian.bitbucket.internal.xcode.analytics.IsXcodeWorkspaceEvent;
import com.atlassian.bitbucket.internal.xcode.analytics.XcodeDisabledEvent;
import com.atlassian.bitbucket.internal.xcode.analytics.XcodeEnabledEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class DefaultXcodeManager
implements XcodeManager {
    static final String EXT_PROJECT = ".xcodeproj";
    static final String EXT_WORKSPACE = ".xcworkspace";
    static final String FILE_PACKAGE_SWIFT = "Package.swift";
    static final int MAX_FILES = 1000;
    static final String PROP_XCODE_ENABLED = "bitbucket.xcode.enabled";
    private final AuthenticationContext authenticationContext;
    private final ContentService contentService;
    private final EventPublisher eventPublisher;
    private final RefService refService;
    private final SecurityService securityService;
    private final UserSettingsService settingsService;
    private final TransactionTemplate transactionTemplate;

    public DefaultXcodeManager(AuthenticationContext authenticationContext, ContentService contentService, EventPublisher eventPublisher, RefService refService, SecurityService securityService, UserSettingsService settingsService, TransactionTemplate transactionTemplate) {
        this.authenticationContext = authenticationContext;
        this.contentService = contentService;
        this.eventPublisher = eventPublisher;
        this.refService = refService;
        this.securityService = securityService;
        this.settingsService = settingsService;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public void autoEnable() {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            return;
        }
        this.securityService.withPermission(Permission.USER_ADMIN, (Object)user, "Auto-enabling \"Clone in Xcode\"").call(() -> {
            this.setEnabled(UserKey.fromLong((long)user.getId()), true, XcodeEnableTrigger.REST);
            return null;
        });
    }

    @Override
    public boolean isEnabled() {
        return this.getCurrentUser().map(this::isEnabled).orElse(Boolean.FALSE);
    }

    @Override
    public boolean isWorkspace(@Nonnull Repository repository) {
        Branch defaultBranch;
        try {
            defaultBranch = this.refService.getDefaultBranch(repository);
        }
        catch (NoDefaultBranchException e) {
            return false;
        }
        final MutableBoolean found = new MutableBoolean();
        this.contentService.streamDirectory(repository, defaultBranch.getId(), "", false, (ContentTreeCallback)new AbstractContentTreeCallback(this){

            public boolean onTreeNode(@Nonnull ContentTreeNode node) {
                if (node.getType() == ContentTreeNode.Type.SUBMODULE) {
                    return true;
                }
                String name = node.getPath().getName();
                if (name.equals(DefaultXcodeManager.FILE_PACKAGE_SWIFT) || name.endsWith(DefaultXcodeManager.EXT_PROJECT) || name.endsWith(DefaultXcodeManager.EXT_WORKSPACE)) {
                    found.setTrue();
                    return false;
                }
                return true;
            }
        }, PageUtils.newRequest((int)0, (int)1000));
        if (found.isTrue()) {
            this.eventPublisher.publish((Object)new IsXcodeWorkspaceEvent(this, repository));
            return true;
        }
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getCurrentUser().ifPresent(user -> this.setEnabled((UserKey)user, enabled, XcodeEnableTrigger.PROFILE));
    }

    private Optional<UserKey> getCurrentUser() {
        return Optional.ofNullable(this.authenticationContext.getCurrentUser()).map(user -> UserKey.fromLong((long)user.getId()));
    }

    private boolean isEnabled(UserKey user) {
        return (Boolean)this.settingsService.getUserSettings(user).getBoolean(PROP_XCODE_ENABLED).getOrElse((Object)Boolean.FALSE);
    }

    private void publishEvent(boolean enabled, XcodeEnableTrigger trigger) {
        this.eventPublisher.publish((Object)(enabled ? new XcodeEnabledEvent(this, trigger) : new XcodeDisabledEvent(this)));
    }

    private void setEnabled(UserKey user, boolean enabled, @Nonnull XcodeEnableTrigger trigger) {
        this.transactionTemplate.execute(() -> {
            if (enabled != this.isEnabled(user)) {
                this.settingsService.updateUserSettings(user, builder -> builder.put(PROP_XCODE_ENABLED, enabled).build());
                this.publishEvent(enabled, trigger);
            }
            return null;
        });
    }
}

