/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.xcode.ui;

import com.atlassian.bitbucket.internal.xcode.XcodeManager;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.view.TemplateRenderingException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class XcodeSettingsFormFragment
implements ContextualFormFragment {
    static final String FIELD_KEY = "enable-xcode";
    static final String SOY_PARAM_ENABLED = "enabled";
    private final RequestManager requestManager;
    private final SoyTemplateRenderer templateRenderer;
    private final XcodeManager xcodeManager;

    public XcodeSettingsFormFragment(RequestManager requestManager, SoyTemplateRenderer templateRenderer, XcodeManager xcodeManager) {
        this.requestManager = requestManager;
        this.templateRenderer = templateRenderer;
        this.xcodeManager = xcodeManager;
    }

    public void doError(@Nonnull Appendable appendable, @Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Collection<String>> fieldErrors, @Nonnull Map<String, Object> context) {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(requestParams, "requestParams");
        Objects.requireNonNull(context, "context");
        this.maybeRenderView(appendable, context, this.isCheckBoxEnabled(requestParams));
    }

    public void doView(@Nonnull Appendable appendable, @Nonnull Map<String, Object> context) {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(context, "context");
        this.maybeRenderView(appendable, context, this.xcodeManager.isEnabled());
    }

    public void execute(@Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Object> context) {
        Objects.requireNonNull(requestParams, "requestParams");
        Objects.requireNonNull(context, "context");
        this.xcodeManager.setEnabled(this.isCheckBoxEnabled(requestParams));
    }

    public void validate(@Nonnull Map<String, String[]> params, @Nonnull ValidationErrors errors, @Nonnull Map<String, Object> context) {
    }

    private boolean isCheckBoxEnabled(Map<String, String[]> requestParams) {
        String[] values = requestParams.get(FIELD_KEY);
        return values != null && values.length == 1 && values[0].equalsIgnoreCase("on");
    }

    private boolean isMac() {
        RequestContext requestContext = this.requestManager.getRequestContext();
        if (requestContext == null) {
            return false;
        }
        Object rawRequest = requestContext.getRawRequest();
        if (rawRequest instanceof HttpServletRequest) {
            return StringUtils.contains((CharSequence)((HttpServletRequest)rawRequest).getHeader("User-Agent"), (CharSequence)"Mac");
        }
        return false;
    }

    private void maybeRenderView(Appendable appendable, Map<String, Object> context, boolean enabled) {
        if (enabled || this.isMac()) {
            context.put(SOY_PARAM_ENABLED, enabled);
            this.renderView(appendable, context);
        }
    }

    private void renderView(Appendable appendable, Map<String, Object> context) {
        try {
            this.templateRenderer.render(appendable, "com.atlassian.bitbucket.server.bitbucket-xcode:xcode-soy-templates", "bitbucketPluginXcode.internal.xcodeSettings.xcodeSettings.enableClone", context);
        }
        catch (SoyException e) {
            throw new TemplateRenderingException("Failed to render bitbucketPluginXcode.internal.xcodeSettings.xcodeSettings.enableClone", (Throwable)e);
        }
    }
}

