/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.xcode.web;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.bitbucket.internal.xcode.XcodeManager;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
public class XcodeUserAgentFilter
implements Filter {
    private static final String USER_AGENT_XCODE = "Xcode/";
    private final XcodeManager xcodeManager;

    public XcodeUserAgentFilter(XcodeManager xcodeManager) {
        this.xcodeManager = xcodeManager;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        if (StringUtils.startsWith((CharSequence)servletRequest.getHeader("User-Agent"), (CharSequence)USER_AGENT_XCODE)) {
            this.xcodeManager.autoEnable();
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
    }
}

