/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth2.client.analytics.StatisticsEvent;
import com.atlassian.oauth2.client.api.ClientConfiguration;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;
import com.atlassian.oauth2.client.api.storage.config.GrantType;
import com.atlassian.oauth2.client.api.storage.config.ProviderType;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;
import com.atlassian.oauth2.client.properties.SystemProperty;
import com.atlassian.oauth2.client.storage.config.dao.ClientConfigStore;
import com.atlassian.oauth2.client.storage.token.dao.ClientTokenStore;
import com.atlassian.oauth2.common.jobs.LifecycleAwareJob;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsCollectionService
extends LifecycleAwareJob {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsCollectionService.class);
    private static final JobId JOB_ID = JobId.of((String)StatisticsCollectionService.class.getName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)StatisticsCollectionService.class.getSimpleName());
    private final ClientConfigStore clientConfigStore;
    private final ClientTokenStore clientTokenStore;
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private final TransactionTemplate transactionTemplate;

    public StatisticsCollectionService(ClientConfigStore clientConfigStore, ClientTokenStore clientTokenStore, ApplicationProperties applicationProperties, EventPublisher eventPublisher, SchedulerService schedulerService, TransactionTemplate transactionTemplate) {
        super(schedulerService);
        this.clientConfigStore = clientConfigStore;
        this.clientTokenStore = clientTokenStore;
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    protected JobRunnerResponse job() {
        StatisticsEvent event = (StatisticsEvent)this.transactionTemplate.execute(this::buildEvent);
        this.eventPublisher.publish((Object)event);
        return JobRunnerResponse.success();
    }

    private StatisticsEvent buildEvent() {
        logger.info("Collecting usage statistics of OAuth 2.0 Client Plugin");
        String platformId = this.applicationProperties.getPlatformId();
        Map<String, ClientConfiguration> idToClientConfiguration = this.fetchConfigTypes();
        Map<String, Long> numberOfConfigsByType = this.countConfigsByType(idToClientConfiguration.values());
        Map<String, Long> numberOfTokensByType = this.countTokensByType(idToClientConfiguration);
        return new StatisticsEvent(platformId, numberOfConfigsByType, numberOfTokensByType);
    }

    private Map<String, ClientConfiguration> fetchConfigTypes() {
        return this.clientConfigStore.list().stream().collect(Collectors.toMap(ClientConfigurationEntity::getId, Function.identity()));
    }

    private Map<String, Long> countTokensByType(Map<String, ClientConfiguration> idToClientConfiguration) {
        List<ClientTokenEntity> tokens = this.clientTokenStore.list();
        List<ClientConfiguration> clientConfigurationsPerToken = tokens.stream().map(ClientTokenEntity::getConfigId).filter(idToClientConfiguration::containsKey).map(idToClientConfiguration::get).collect(Collectors.toList());
        return this.countConfigsByType(clientConfigurationsPerToken);
    }

    private Map<String, Long> countConfigsByType(Collection<ClientConfiguration> clientConfigurations) {
        Map<GrantType, Map<ProviderType, Long>> grantTypeToProviderTypeCounts = clientConfigurations.stream().collect(Collectors.groupingBy(ClientConfiguration::getGrantType, Collectors.groupingBy(ClientConfiguration::getProviderType, Collectors.counting())));
        return this.calculateTotalCounts(grantTypeToProviderTypeCounts);
    }

    private Map<String, Long> calculateTotalCounts(Map<GrantType, Map<ProviderType, Long>> grantTypeToProviderTypeCounts) {
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (GrantType grantType2 : GrantType.values()) {
            for (ProviderType providerType : ProviderType.values()) {
                String key = grantType2.getName() + "." + providerType.getKey();
                counts.putIfAbsent(key, 0L);
            }
        }
        grantTypeToProviderTypeCounts.forEach((grantType, providerTypeCounts) -> providerTypeCounts.forEach((providerType, count) -> {
            String key = grantType.getName() + "." + providerType.getKey();
            counts.computeIfPresent(key, (ignore, v) -> v + count);
        }));
        return counts;
    }

    @Override
    protected JobId getJobId() {
        return JOB_ID;
    }

    @Override
    protected JobRunnerKey getJobRunnerKey() {
        return JOB_RUNNER_KEY;
    }

    @Override
    protected JobConfig getJobConfig() {
        return JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withSchedule(Schedule.forCronExpression((String)SystemProperty.CLIENT_STATISTICS_COLLECTION_SCHEDULE.getValue())).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
    }
}

