/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.config.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.oauth2.client.security.ClientPluginSecretServicePath;
import com.atlassian.oauth2.client.storage.config.dao.entity.AOClientConfig;
import com.atlassian.oauth2.client.storage.token.dao.entity.AOClientToken;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceState;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask01SecretService
implements PluginUpgradeTask {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeTask01SecretService.class);
    private final ActiveObjects activeObjects;
    private final SecretService secretService;

    public UpgradeTask01SecretService(ActiveObjects activeObjects, SecretService secretService) {
        this.activeObjects = activeObjects;
        this.secretService = secretService;
    }

    public int getBuildNumber() {
        return 1;
    }

    @Nonnull
    public String getShortDescription() {
        return "Migrating client plugin secrets to secret storage";
    }

    public Collection<Message> doUpgrade() {
        if (SecretService.getState() == SecretServiceState.ENABLED) {
            this.activeObjects.executeInTransaction(() -> {
                logger.info("Secret service enabled, migrating client plugin secrets");
                this.migrateClientSecrets();
                this.migrateClientTokenSecrets();
                return null;
            });
        } else {
            logger.info("Warning: secret service is disabled, skipping migration of client plugin secrets");
        }
        return Collections.emptyList();
    }

    private void migrateClientSecrets() {
        logger.info("migrating client secrets");
        Arrays.stream((AOClientConfig[])this.activeObjects.find(AOClientConfig.class)).forEach(clientConfig -> {
            logger.debug("Migrating client configuration [{}] to secret service", (Object)clientConfig.getId());
            this.secretService.put(ClientPluginSecretServicePath.clientSecretPath(clientConfig.getId()), clientConfig.getClientSecret());
            clientConfig.setClientSecret("{ATL_SECURED}");
            if (clientConfig.getClientCertificate() != null) {
                logger.debug("Adding client certificate to  [{}] to secret service", (Object)clientConfig.getId());
                this.secretService.put(ClientPluginSecretServicePath.clientCertificatePath(clientConfig.getId()), clientConfig.getClientCertificate());
                clientConfig.setClientCertificate("{ATL_SECURED}");
            }
            clientConfig.save();
        });
    }

    private void migrateClientTokenSecrets() {
        logger.info("migrating client tokens");
        Arrays.stream((AOClientToken[])this.activeObjects.find(AOClientToken.class)).forEach(token -> {
            logger.debug("Migrating access token [{}] to secret service", (Object)token.getId());
            this.secretService.put(ClientPluginSecretServicePath.accessTokenPath(token.getId()), token.getAccessToken());
            token.setAccessToken("{ATL_SECURED}");
            if (token.getRefreshToken() != null) {
                logger.debug("Migrating refresh token [{}] to secret service", (Object)token.getId());
                this.secretService.put(ClientPluginSecretServicePath.refreshTokenPath(token.getId()), token.getRefreshToken());
                token.setRefreshToken("{ATL_SECURED}");
            }
            token.save();
        });
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.oauth2.oauth2-client-plugin";
    }
}

