/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.lib;

import com.atlassian.oauth2.client.api.ClientConfiguration;
import com.atlassian.oauth2.client.api.storage.config.GrantType;
import com.atlassian.oauth2.client.api.storage.config.ProviderType;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ClientConfigurationImpl
implements ClientConfiguration,
Serializable {
    private static final long serialVersionUID = 2992149181956490064L;
    private final GrantType grantType;
    private final ProviderType providerType;
    private final String clientId;
    private final String clientSecret;
    private final String clientCertificate;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;
    private final List<String> scopes;
    private final Map<String, List<String>> customParams;

    private ClientConfigurationImpl(Builder builder) {
        GrantType determineGrantType = GrantType.orDefaultGrantType((GrantType)builder.grantType);
        String determineAuthEndpoint = determineGrantType.requiresAuthorization() ? builder.authorizationEndpoint : "";
        this.grantType = determineGrantType;
        this.providerType = Objects.requireNonNull(builder.providerType, "Provider type cannot be null");
        this.clientId = Objects.requireNonNull(builder.clientId, "Client ID cannot be null");
        this.clientSecret = Objects.requireNonNull(builder.clientSecret, "Client secret cannot be null");
        this.clientCertificate = builder.clientCertificate;
        this.authorizationEndpoint = Objects.requireNonNull(determineAuthEndpoint, "Authorization endpoint cannot be null");
        this.tokenEndpoint = Objects.requireNonNull(builder.tokenEndpoint, "Token endpoint cannot be null");
        this.scopes = ImmutableList.copyOf(builder.scopes);
        this.customParams = ImmutableMap.copyOf(builder.customParams);
    }

    @Nonnull
    public String getClientId() {
        return this.clientId;
    }

    @Nonnull
    public String getClientSecret() {
        return this.clientSecret;
    }

    public Optional<String> getClientCertificate() {
        return Optional.ofNullable(this.clientCertificate);
    }

    @Nonnull
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    @Nonnull
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @Nonnull
    public List<String> getScopes() {
        return this.scopes;
    }

    @Nonnull
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Nonnull
    public ProviderType getProviderType() {
        return this.providerType;
    }

    @Nonnull
    public Map<String, List<String>> getCustomParams() {
        return this.customParams;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(ClientConfiguration data) {
        return new Builder(data);
    }

    @Nonnull
    public static ClientConfigurationImpl from(ClientConfiguration configuration) {
        return configuration instanceof ClientConfigurationImpl ? (ClientConfigurationImpl)configuration : ClientConfigurationImpl.builder(configuration).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientConfigurationImpl that = (ClientConfigurationImpl)o;
        return Objects.equals(this.getGrantType(), that.getGrantType()) && Objects.equals(this.getProviderType(), that.getProviderType()) && Objects.equals(this.getClientId(), that.getClientId()) && Objects.equals(this.getClientSecret(), that.getClientSecret()) && Objects.equals(this.getClientCertificate(), that.getClientCertificate()) && Objects.equals(this.getAuthorizationEndpoint(), that.getAuthorizationEndpoint()) && Objects.equals(this.getTokenEndpoint(), that.getTokenEndpoint()) && Objects.equals(this.getScopes(), that.getScopes());
    }

    public int hashCode() {
        return Objects.hash(this.getGrantType(), this.getProviderType(), this.getClientId(), this.getClientSecret(), this.getClientCertificate(), this.getAuthorizationEndpoint(), this.getTokenEndpoint(), this.getScopes());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("grantType", (Object)this.getGrantType()).add("providerType", (Object)this.getProviderType()).add("clientId", (Object)this.getClientId()).add("clientSecret", (Object)"*****").add("authorizationEndpoint", (Object)this.getAuthorizationEndpoint()).add("tokenEndpoint", (Object)this.getTokenEndpoint()).add("scopes", this.getScopes()).toString();
    }

    public static final class Builder {
        private GrantType grantType;
        private ProviderType providerType;
        private String clientId;
        private String clientSecret;
        private String clientCertificate;
        private String authorizationEndpoint;
        private String tokenEndpoint;
        private List<String> scopes = new ArrayList<String>();
        private Map<String, List<String>> customParams = new HashMap<String, List<String>>();

        private Builder() {
        }

        private Builder(ClientConfiguration initialData) {
            this.grantType = initialData.getGrantType();
            this.providerType = initialData.getProviderType();
            this.clientId = initialData.getClientId();
            this.clientSecret = initialData.getClientSecret();
            this.clientCertificate = initialData.getClientCertificate().orElse(null);
            this.authorizationEndpoint = initialData.getAuthorizationEndpoint();
            this.tokenEndpoint = initialData.getTokenEndpoint();
            this.scopes = new ArrayList<String>(initialData.getScopes());
            this.customParams = new HashMap<String, List<String>>(initialData.getCustomParams());
        }

        public Builder grantType(GrantType grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder providerType(ProviderType providerType) {
            this.providerType = providerType;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder clientCertificate(String clientCertificate) {
            this.clientCertificate = clientCertificate;
            return this;
        }

        public Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public Builder scopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder customParams(Map<String, List<String>> customParams) {
            this.customParams = customParams;
            return this;
        }

        public ClientConfigurationImpl build() {
            return new ClientConfigurationImpl(this);
        }
    }
}

