/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.lib.secrets;

import com.atlassian.oauth2.client.api.ClientConfiguration;
import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.lib.token.TokenServiceException;
import com.atlassian.oauth2.client.lib.ClientTokenImpl;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAuthorizationService {
    private static final Base64.Decoder DECODER = Base64.getUrlDecoder();
    private static final Logger logger = LoggerFactory.getLogger(GoogleAuthorizationService.class);

    private GoogleAuthorizationService() {
    }

    public static ClientToken generateClientCredentialsAccessToken(ClientConfiguration config) throws TokenServiceException {
        String encodedCertificate = (String)config.getClientCertificate().orElseThrow(() -> new TokenServiceException("Client credentials for Google requires a valid json certificate"));
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(DECODER.decode(encodedCertificate));
            GoogleCredentials credentials = GoogleCredentials.fromStream(inputStream).createDelegated(config.getClientId()).createScoped(config.getScopes());
            credentials.refreshIfExpired();
            AccessToken accessToken = credentials.getAccessToken();
            return ClientTokenImpl.builder().accessToken(accessToken.getTokenValue()).accessTokenExpiration(accessToken.getExpirationTime().toInstant()).build();
        }
        catch (IOException e) {
            logger.error("Error while fetching credentials from Google", (Throwable)e);
            throw new TokenServiceException((Throwable)e);
        }
    }
}

