/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.rest.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestErrorCollection {
    @XmlElement
    private final List<String> errors;
    @XmlElement
    private final Map<String, List<String>> fieldErrors;

    public RestErrorCollection() {
        this(Collections.emptyList(), Collections.emptyMap());
    }

    public RestErrorCollection(@Nonnull List<String> errors, @Nonnull Map<String, List<String>> fieldErrors) {
        this.errors = ImmutableList.copyOf(errors);
        this.fieldErrors = ImmutableMap.copyOf((Map)Maps.transformValues(fieldErrors, ImmutableList::copyOf));
    }

    @Nonnull
    public List<String> getErrors() {
        return this.errors;
    }

    @Nonnull
    public Map<String, List<String>> getFieldErrors() {
        return this.fieldErrors;
    }
}

