/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.storage.config.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.oauth2.client.api.ClientConfiguration;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;
import com.atlassian.oauth2.client.api.storage.config.GrantType;
import com.atlassian.oauth2.client.api.storage.config.ProviderType;
import com.atlassian.oauth2.client.api.storage.token.exception.ConfigurationNotFoundException;
import com.atlassian.oauth2.client.storage.config.dao.ClientConfigStore;
import com.atlassian.oauth2.client.storage.config.dao.entity.AOClientConfig;
import com.atlassian.oauth2.client.util.ClientHttpsValidator;
import com.atlassian.oauth2.common.IdGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.StringUtils;

public class ClientConfigStoreImpl
implements ClientConfigStore {
    private static final String DELIMITER = " ";
    private final IdGenerator idGenerator;
    private final ClientHttpsValidator clientHttpsValidator;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ActiveObjects activeObjects;

    public ClientConfigStoreImpl(ActiveObjects activeObjects, IdGenerator idGenerator, ClientHttpsValidator clientHttpsValidator) {
        this.activeObjects = activeObjects;
        this.idGenerator = idGenerator;
        this.clientHttpsValidator = clientHttpsValidator;
    }

    @Override
    public void delete(@Nonnull String id) throws ConfigurationNotFoundException {
        AOClientConfig client = this.findByIdOrFail(id);
        this.activeObjects.delete(new RawEntity[]{client});
    }

    @Override
    @Nonnull
    public ClientConfigurationEntity create(@Nonnull ClientConfigurationEntity clientConfigurationEntity) {
        this.assertValid(clientConfigurationEntity);
        String newId = this.idGenerator.generate();
        ImmutableMap.Builder configProperties = ImmutableMap.builder().put((Object)"ID", (Object)newId).put((Object)"NAME", (Object)clientConfigurationEntity.getName()).put((Object)"TYPE", (Object)clientConfigurationEntity.getProviderType().key).put((Object)"CLIENT_ID", (Object)clientConfigurationEntity.getClientId()).put((Object)"CLIENT_SECRET", (Object)clientConfigurationEntity.getClientSecret()).put((Object)"AUTHORIZATION_ENDPOINT", (Object)clientConfigurationEntity.getAuthorizationEndpoint()).put((Object)"TOKEN_ENDPOINT", (Object)clientConfigurationEntity.getTokenEndpoint()).put((Object)"SCOPES", (Object)this.listToDelimited(clientConfigurationEntity.getScopes())).put((Object)"GRANT_TYPE", (Object)clientConfigurationEntity.getGrantType().getName()).put((Object)"CUSTOM_PARAMS", (Object)this.toJson(clientConfigurationEntity.getCustomParams()));
        Optional.ofNullable(clientConfigurationEntity.getDescription()).ifPresent(description -> configProperties.put((Object)"DESCRIPTION", description));
        clientConfigurationEntity.getClientCertificate().ifPresent(certificate -> configProperties.put((Object)"CLIENT_CERTIFICATE", certificate));
        this.activeObjects.create(AOClientConfig.class, (Map)configProperties.build());
        return ClientConfigurationEntity.builder((ClientConfigurationEntity)clientConfigurationEntity).id(newId).build();
    }

    @Override
    @Nonnull
    public ClientConfigurationEntity update(ClientConfigurationEntity clientConfigurationEntity) throws ConfigurationNotFoundException {
        this.assertValid(clientConfigurationEntity);
        AOClientConfig clientConfig = this.findByIdOrFail(clientConfigurationEntity.getId());
        this.updateClientConfiguration(clientConfig, clientConfigurationEntity);
        return clientConfigurationEntity;
    }

    private void updateClientConfiguration(AOClientConfig clientConfig, ClientConfigurationEntity clientConfigurationEntity) {
        clientConfig.setName(clientConfigurationEntity.getName());
        clientConfig.setDescription(clientConfigurationEntity.getDescription());
        clientConfig.setType(clientConfigurationEntity.getProviderType().key);
        clientConfig.setGrantType(clientConfigurationEntity.getGrantType().getName());
        clientConfig.setClientId(clientConfigurationEntity.getClientId());
        clientConfig.setClientSecret(clientConfigurationEntity.getClientSecret());
        clientConfig.setClientCertificate(clientConfigurationEntity.getClientCertificate().orElse(null));
        clientConfig.setAuthorizationEndpoint(clientConfigurationEntity.getAuthorizationEndpoint());
        clientConfig.setTokenEndpoint(clientConfigurationEntity.getTokenEndpoint());
        clientConfig.setScopes(this.listToDelimited(clientConfigurationEntity.getScopes()));
        clientConfig.setCustomParams(this.toJson(clientConfigurationEntity.getCustomParams()));
        clientConfig.save();
    }

    private void assertValid(ClientConfigurationEntity config) {
        this.clientHttpsValidator.assertSecure((ClientConfiguration)config);
    }

    @Override
    public boolean isNameUnique(@Nullable String id, @Nonnull String name) {
        return this.isUnique(id, "NAME = ?", name);
    }

    private boolean isUnique(String id, String where, String ... params) {
        Query query = Query.select((String)"ID");
        if (id == null) {
            query.setWhereClause(where);
            query.setWhereParams((Object[])params);
        } else {
            query.setWhereClause("(" + where + ") AND ID<> ?");
            query.setWhereParams(ArrayUtils.add((Object[])params, (Object)id));
        }
        return this.activeObjects.count(AOClientConfig.class, query) == 0;
    }

    private String listToDelimited(List<String> scopes) {
        return StringUtils.collectionToDelimitedString(scopes, (String)DELIMITER);
    }

    private String toJson(Map<String, List<String>> customParams) {
        try {
            return this.objectMapper.writeValueAsString(customParams);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error while serializing custom params", e);
        }
    }

    private Map<String, List<String>> fromJson(String customParams) {
        if (customParams == null) {
            return new HashMap<String, List<String>>();
        }
        try {
            TypeReference<Map<String, List<String>>> typeRef = new TypeReference<Map<String, List<String>>>(this){};
            return (Map)this.objectMapper.readValue(customParams, (TypeReference)typeRef);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error while deserializing custom params", e);
        }
    }

    @Override
    @Nullable
    public ClientConfigurationEntity getById(@Nonnull String id) {
        return this.findById(id).map(this::toEntity).orElse(null);
    }

    @Override
    @Nonnull
    public ClientConfigurationEntity getByIdOrFail(@Nonnull String id) throws ConfigurationNotFoundException {
        return this.toEntity(this.findByIdOrFail(id));
    }

    private AOClientConfig findByIdOrFail(@Nonnull String id) throws ConfigurationNotFoundException {
        return this.findById(id).orElseThrow(() -> new ConfigurationNotFoundException("Configuration {" + id + "} does not exist"));
    }

    private Optional<AOClientConfig> findById(@Nonnull String id) {
        return Optional.ofNullable((AOClientConfig)this.activeObjects.get(AOClientConfig.class, (Object)id));
    }

    @Override
    @Nonnull
    public List<ClientConfigurationEntity> list() {
        return Arrays.stream((AOClientConfig[])this.activeObjects.find(AOClientConfig.class, Query.select().order("NAME ASC"))).map(this::toEntity).collect(Collectors.toList());
    }

    @Override
    public Optional<ClientConfigurationEntity> getByName(String configName) {
        return Arrays.stream((AOClientConfig[])this.activeObjects.find(AOClientConfig.class, Query.select().where("NAME = ?", new Object[]{configName}))).findFirst().map(this::toEntity);
    }

    private ClientConfigurationEntity toEntity(AOClientConfig aoClientConfig) {
        GrantType grantType = GrantType.getByNameOrDefault((String)aoClientConfig.getGrantType());
        return ClientConfigurationEntity.builder().id(aoClientConfig.getId()).name(aoClientConfig.getName()).description(aoClientConfig.getDescription()).providerType(ProviderType.getOrThrow((String)aoClientConfig.getType())).clientId(aoClientConfig.getClientId()).clientSecret(aoClientConfig.getClientSecret()).clientCertificate(aoClientConfig.getClientCertificate()).authorizationEndpoint(aoClientConfig.getAuthorizationEndpoint()).tokenEndpoint(aoClientConfig.getTokenEndpoint()).scopes(this.delimitedToList(aoClientConfig.getScopes())).grantType(grantType).customParams(this.fromJson(aoClientConfig.getCustomParams())).build();
    }

    private List<String> delimitedToList(String scopes) {
        return Arrays.asList(StringUtils.delimitedListToStringArray((String)scopes, (String)DELIMITER));
    }
}

