/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.storage.config.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;
import com.atlassian.oauth2.client.api.storage.token.exception.ConfigurationNotFoundException;
import com.atlassian.oauth2.client.security.ClientPluginSecretServicePath;
import com.atlassian.oauth2.client.storage.AbstractStore;
import com.atlassian.oauth2.client.storage.config.dao.ClientConfigStore;
import com.atlassian.oauth2.client.storage.config.dao.ClientConfigStoreImpl;
import com.atlassian.oauth2.client.util.ClientHttpsValidator;
import com.atlassian.oauth2.common.IdGenerator;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredClientConfigStore
extends AbstractStore
implements ClientConfigStore {
    private static final Logger logger = LoggerFactory.getLogger(SecuredClientConfigStore.class);
    private final SecretService secretService;
    private final ClientConfigStoreImpl baseClientConfigStore;

    public SecuredClientConfigStore(ActiveObjects activeObjects, IdGenerator idGenerator, ClientHttpsValidator clientHttpsValidator, SecretService service) {
        super(activeObjects);
        this.baseClientConfigStore = new ClientConfigStoreImpl(activeObjects, idGenerator, clientHttpsValidator);
        this.secretService = service;
    }

    @Override
    public void delete(@Nonnull String configurationId) throws ConfigurationNotFoundException {
        this.executeInTransaction(() -> {
            this.baseClientConfigStore.delete(configurationId);
            this.secretService.delete(ClientPluginSecretServicePath.clientSecretPath(configurationId));
            this.secretService.delete(ClientPluginSecretServicePath.clientCertificatePath(configurationId));
            return null;
        }, ConfigurationNotFoundException.class);
    }

    @Override
    @Nonnull
    public ClientConfigurationEntity create(@Nonnull ClientConfigurationEntity clientConfigurationEntity) {
        return (ClientConfigurationEntity)this.activeObjects.executeInTransaction(() -> {
            if (this.isSecretServiceDisabled()) {
                logger.debug("Warning: SecretService is disabled, creating client configuration without encryption");
                return this.baseClientConfigStore.create(clientConfigurationEntity);
            }
            String clientSecret = clientConfigurationEntity.getClientSecret();
            Optional maybeClientCertificate = clientConfigurationEntity.getClientCertificate();
            ClientConfigurationEntity sanitizedEntity = this.sanitizeSecretFields(clientConfigurationEntity);
            ClientConfigurationEntity createdConfig = this.baseClientConfigStore.create(sanitizedEntity);
            this.secretService.put(ClientPluginSecretServicePath.clientSecretPath(createdConfig.getId()), clientSecret);
            maybeClientCertificate.ifPresent(s -> this.secretService.put(ClientPluginSecretServicePath.clientCertificatePath(createdConfig.getId()), s));
            return this.populateSecretFields(createdConfig, clientSecret, maybeClientCertificate.orElse(null));
        });
    }

    @Override
    @Nonnull
    public ClientConfigurationEntity update(@Nonnull ClientConfigurationEntity clientConfigurationEntity) throws ConfigurationNotFoundException {
        return this.executeInTransaction(() -> {
            if (this.isSecretServiceDisabled()) {
                logger.debug("Warning: SecretService is disabled, updating client configuration without encryption");
                return this.baseClientConfigStore.update(clientConfigurationEntity);
            }
            String clientSecret = clientConfigurationEntity.getClientSecret();
            Optional maybeClientCertificate = clientConfigurationEntity.getClientCertificate();
            ClientConfigurationEntity sanitizedEntity = this.sanitizeSecretFields(clientConfigurationEntity);
            this.baseClientConfigStore.update(sanitizedEntity);
            this.secretService.put(ClientPluginSecretServicePath.clientSecretPath(clientConfigurationEntity.getId()), clientSecret);
            if (maybeClientCertificate.isPresent()) {
                this.secretService.put(ClientPluginSecretServicePath.clientCertificatePath(clientConfigurationEntity.getId()), (String)maybeClientCertificate.get());
            } else {
                this.secretService.delete(ClientPluginSecretServicePath.clientCertificatePath(clientConfigurationEntity.getId()));
            }
            return clientConfigurationEntity;
        }, ConfigurationNotFoundException.class);
    }

    @Override
    @Nullable
    public ClientConfigurationEntity getById(@Nonnull String id) {
        return (ClientConfigurationEntity)this.activeObjects.executeInTransaction(() -> Optional.ofNullable(this.baseClientConfigStore.getById(id)).map(this::populateSecretFields).orElse(null));
    }

    @Override
    @Nonnull
    public ClientConfigurationEntity getByIdOrFail(@Nonnull String id) throws ConfigurationNotFoundException {
        return this.populateSecretFields(this.baseClientConfigStore.getByIdOrFail(id));
    }

    @Override
    @Nonnull
    public List<ClientConfigurationEntity> list() {
        return this.baseClientConfigStore.list().stream().map(this::populateSecretFields).toList();
    }

    @Override
    public boolean isNameUnique(@Nullable String id, @Nonnull String name) {
        return (Boolean)this.activeObjects.executeInTransaction(() -> this.baseClientConfigStore.isNameUnique(id, name));
    }

    @Override
    public Optional<ClientConfigurationEntity> getByName(String configName) {
        return this.baseClientConfigStore.getByName(configName).map(this::populateSecretFields);
    }

    private ClientConfigurationEntity populateSecretFields(ClientConfigurationEntity clientConfig, String clientSecret, String clientCertificate) {
        return clientConfig.toBuilder().clientSecret(clientSecret).clientCertificate(clientCertificate).build();
    }

    private ClientConfigurationEntity populateSecretFields(ClientConfigurationEntity clientConfig) {
        if (this.isSecretServiceDisabled()) {
            if ("{ATL_SECURED}".equals(clientConfig.getClientSecret())) {
                throw new SecretServiceException("Secret service is disabled, but client secret is marked as secured.");
            }
            if (clientConfig.getClientCertificate().isPresent() && "{ATL_SECURED}".equals(clientConfig.getClientCertificate().get())) {
                throw new SecretServiceException("Secret service is disabled, but client certificate is marked as secured.");
            }
            return clientConfig;
        }
        Optional maybeClientSecret = this.secretService.get(ClientPluginSecretServicePath.clientSecretPath(clientConfig.getId()));
        String clientCertificate = this.secretService.get(ClientPluginSecretServicePath.clientCertificatePath(clientConfig.getId())).orElse(null);
        if (maybeClientSecret.isEmpty()) {
            logger.error("Failed to retrieve secrets from secret service for client configuration id [{}].", (Object)clientConfig.getId());
        }
        return clientConfig.toBuilder().clientSecret(maybeClientSecret.orElse("")).clientCertificate(clientCertificate).build();
    }

    private ClientConfigurationEntity sanitizeSecretFields(ClientConfigurationEntity clientConfig) {
        String cert = clientConfig.getClientCertificate().isPresent() ? "{ATL_SECURED}" : null;
        return clientConfig.toBuilder().clientSecret("{ATL_SECURED}").clientCertificate(cert).build();
    }

    private boolean isSecretServiceDisabled() {
        return SecretService.getState() == SecretServiceState.DISABLED;
    }
}

