/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.storage.token;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.storage.event.ClientTokenCreatedEvent;
import com.atlassian.oauth2.client.api.storage.event.ClientTokenDeletedEvent;
import com.atlassian.oauth2.client.api.storage.event.ClientTokenUpdatedEvent;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;
import com.atlassian.oauth2.client.api.storage.token.exception.TokenNotFoundException;
import com.atlassian.oauth2.client.api.storage.token.exception.TokenStorageServiceException;
import com.atlassian.oauth2.client.storage.token.InternalClientTokenStorageService;
import com.atlassian.oauth2.client.storage.token.dao.ClientTokenStore;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public class DefaultClientTokenStorageService
implements InternalClientTokenStorageService {
    private final ClientTokenStore clientTokenStore;
    private final EventPublisher eventPublisher;

    public DefaultClientTokenStorageService(ClientTokenStore clientTokenStore, EventPublisher eventPublisher) {
        this.clientTokenStore = clientTokenStore;
        this.eventPublisher = eventPublisher;
    }

    @Nonnull
    public ClientTokenEntity save(@Nonnull ClientTokenEntity clientToken) throws TokenNotFoundException {
        ClientTokenEntity savedToken;
        if (clientToken.getId() == null) {
            savedToken = this.clientTokenStore.create(clientToken);
            this.eventPublisher.publish((Object)new ClientTokenCreatedEvent(savedToken.getId()));
        } else {
            savedToken = this.clientTokenStore.updateOrFail(clientToken);
            this.eventPublisher.publish((Object)new ClientTokenUpdatedEvent(savedToken.getId()));
        }
        return savedToken;
    }

    public void delete(@Nonnull String id) throws TokenNotFoundException {
        this.clientTokenStore.delete(id);
        this.eventPublisher.publish((Object)new ClientTokenDeletedEvent(id));
    }

    @Nonnull
    public Optional<ClientTokenEntity> getById(@Nonnull String id) {
        return Optional.ofNullable(this.clientTokenStore.getById(id));
    }

    @Nonnull
    public ClientTokenEntity getByIdOrFail(@Nonnull String id) throws TokenNotFoundException {
        return this.clientTokenStore.getByIdOrFail(id);
    }

    @Nonnull
    public List<ClientTokenEntity> getAccessTokensExpiringBefore(@Nonnull Instant timestamp) {
        return this.clientTokenStore.getAccessTokensExpiringBefore(timestamp);
    }

    @Nonnull
    public List<ClientTokenEntity> getRefreshTokensExpiringBefore(@Nonnull Instant timestamp) {
        return this.clientTokenStore.getRefreshTokensExpiringBefore(timestamp);
    }

    @Override
    public Optional<ClientTokenEntity> getByExternalIdAndConfigId(String externalId, String configId) {
        return this.clientTokenStore.getByExternalIdAndConfigId(externalId, configId);
    }

    @Override
    public ClientTokenEntity createOrUpdate(ClientToken clientToken, String externalId, String configId) {
        return this.clientTokenStore.getByExternalIdAndConfigId(externalId, configId).map(existingToken -> {
            ClientTokenEntity updatedToken = ClientTokenEntity.builder((ClientTokenEntity)existingToken).updateFrom(clientToken).build();
            ClientTokenEntity newToken = this.clientTokenStore.update(updatedToken).orElseThrow(() -> new TokenStorageServiceException("Failed to update the existing token"));
            this.eventPublisher.publish((Object)new ClientTokenUpdatedEvent(newToken.getId()));
            return newToken;
        }).orElseGet(() -> {
            ClientTokenEntity newToken = this.clientTokenStore.create(clientToken, externalId, configId);
            this.eventPublisher.publish((Object)new ClientTokenCreatedEvent(newToken.getId()));
            return newToken;
        });
    }

    @Override
    public boolean deleteTokenByValue(String tokenValue) {
        return this.clientTokenStore.deleteByTokenValue(tokenValue);
    }
}

