/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.storage.token.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.ClientTokenMetadata;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;
import com.atlassian.oauth2.client.api.storage.token.exception.TokenNotFoundException;
import com.atlassian.oauth2.client.storage.token.dao.ClientTokenStore;
import com.atlassian.oauth2.client.storage.token.dao.entity.AOClientToken;
import com.atlassian.oauth2.common.IdGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class ClientTokenStoreImpl
implements ClientTokenStore {
    private final IdGenerator idGenerator;
    private final ActiveObjects activeObjects;

    public ClientTokenStoreImpl(ActiveObjects activeObjects, IdGenerator idGenerator) {
        this.activeObjects = activeObjects;
        this.idGenerator = idGenerator;
    }

    @Override
    @Nonnull
    public ClientTokenEntity create(@Nonnull ClientTokenEntity clientTokenEntity) {
        String newId = this.idGenerator.generate();
        HashMap<String, Object> tokenProperties = new HashMap<String, Object>();
        tokenProperties.put("ID", newId);
        tokenProperties.put("CONFIG_ID", clientTokenEntity.getConfigId());
        tokenProperties.put("ACCESS_TOKEN", clientTokenEntity.getAccessToken());
        tokenProperties.put("ACCESS_TOKEN_EXPIRATION", clientTokenEntity.getAccessTokenExpiration().toEpochMilli());
        tokenProperties.put("REFRESH_TOKEN", clientTokenEntity.getRefreshToken());
        tokenProperties.put("REFRESH_TOKEN_EXPIRATION", this.toEpochMilli(clientTokenEntity.getRefreshTokenExpiration()));
        tokenProperties.put("STATUS", clientTokenEntity.getStatus().name());
        tokenProperties.put("REFRESH_COUNT", clientTokenEntity.getRefreshCount());
        tokenProperties.put("LAST_REFRESHED", this.toEpochMilli(clientTokenEntity.getLastRefreshed()));
        tokenProperties.put("LAST_STATUS_UPDATED", this.toEpochMilli(clientTokenEntity.getLastStatusUpdated()));
        tokenProperties.put("EXTERNAL_ID", clientTokenEntity.getExternalId());
        this.activeObjects.create(AOClientToken.class, tokenProperties);
        return this.truncatedToMillis(clientTokenEntity).id(newId).build();
    }

    @Override
    @Nonnull
    public ClientTokenEntity create(@Nonnull ClientToken clientToken, @Nullable String externalId, @Nonnull String configId) {
        ClientTokenEntity clientTokenEntity = ClientTokenEntity.builder((ClientToken)clientToken).lastStatusUpdated(Instant.now()).externalId(externalId).configId(configId).build();
        return this.create(clientTokenEntity);
    }

    @Override
    @Nonnull
    public Optional<ClientTokenEntity> update(@Nonnull ClientTokenEntity clientTokenEntity) {
        return this.findById(clientTokenEntity.getId()).map(aoClientToken -> {
            this.updateClientToken((AOClientToken)aoClientToken, clientTokenEntity);
            return this.truncatedToMillis(clientTokenEntity).build();
        });
    }

    @Override
    @Nonnull
    public ClientTokenEntity updateOrFail(@Nonnull ClientTokenEntity clientTokenEntity) throws TokenNotFoundException {
        return this.update(clientTokenEntity).orElseThrow(() -> new TokenNotFoundException("Token {" + clientTokenEntity.getId() + "} does not exist"));
    }

    @Override
    public void delete(@Nonnull String id) throws TokenNotFoundException {
        AOClientToken token = this.findByIdOrFail(id);
        this.activeObjects.delete(new RawEntity[]{token});
    }

    @Override
    public List<String> deleteWithConfigId(@Nonnull String configId) {
        Query where = this.selectQuery().where("CONFIG_ID = ?", new Object[]{configId});
        return this.deleteTokens(where);
    }

    @Override
    public List<String> deleteTokensExpiringBefore(@Nonnull Instant timestamp) {
        return this.deleteTokens(this.selectQuery().where("REFRESH_TOKEN_EXPIRATION < ? AND ACCESS_TOKEN_EXPIRATION < ?", new Object[]{timestamp.toEpochMilli(), timestamp.toEpochMilli()}));
    }

    @Override
    public List<String> deleteTokensUnrecoverableSince(@Nonnull Instant timestamp) {
        return this.deleteTokens(this.selectQuery().where("STATUS = ? AND LAST_STATUS_UPDATED < ?", new Object[]{ClientTokenMetadata.ClientTokenStatus.UNRECOVERABLE, timestamp.toEpochMilli()}));
    }

    private List<String> deleteTokens(Query whereClause) {
        RawEntity[] aoClientTokens = (AOClientToken[])this.activeObjects.find(AOClientToken.class, whereClause);
        this.activeObjects.delete(aoClientTokens);
        return Arrays.stream(aoClientTokens).map(AOClientToken::getId).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public ClientTokenEntity getById(@Nonnull String id) {
        return this.findById(id).map(this::toEntity).orElse(null);
    }

    @Override
    @Nonnull
    public ClientTokenEntity getByIdOrFail(@Nonnull String id) throws TokenNotFoundException {
        return this.toEntity(this.findByIdOrFail(id));
    }

    @Override
    public Optional<ClientTokenEntity> getByExternalIdAndConfigId(@Nonnull String externalId, @Nonnull String configId) {
        return (Optional)this.activeObjects.executeInTransaction(() -> this.fetchFirstResult(this.selectQuery().where(String.format("%s = ? AND %s = ?", "EXTERNAL_ID", "CONFIG_ID"), new Object[]{externalId, configId})));
    }

    private AOClientToken findByIdOrFail(@Nonnull String id) throws TokenNotFoundException {
        return this.findById(id).orElseThrow(() -> new TokenNotFoundException("Token {" + id + "} does not exist"));
    }

    private Optional<AOClientToken> findById(@Nonnull String id) {
        return Optional.ofNullable((AOClientToken)this.activeObjects.get(AOClientToken.class, (Object)id));
    }

    private void updateClientToken(AOClientToken aoClientToken, ClientTokenEntity clientTokenEntity) {
        aoClientToken.setConfigId(clientTokenEntity.getConfigId());
        aoClientToken.setAccessToken(clientTokenEntity.getAccessToken());
        aoClientToken.setAccessTokenExpiration(clientTokenEntity.getAccessTokenExpiration().toEpochMilli());
        aoClientToken.setRefreshToken(clientTokenEntity.getRefreshToken());
        aoClientToken.setRefreshTokenExpiration(this.toEpochMilli(clientTokenEntity.getRefreshTokenExpiration()));
        aoClientToken.setStatus(clientTokenEntity.getStatus().name());
        aoClientToken.setLastRefreshed(this.toEpochMilli(clientTokenEntity.getLastRefreshed()));
        aoClientToken.setRefreshCount(clientTokenEntity.getRefreshCount());
        aoClientToken.setLastStatusUpdated(this.toEpochMilli(clientTokenEntity.getLastStatusUpdated()));
        aoClientToken.setExternalId(clientTokenEntity.getExternalId());
        aoClientToken.save();
    }

    @Override
    @Nonnull
    public List<ClientTokenEntity> getAccessTokensExpiringBefore(@Nonnull Instant timestamp) {
        return this.fetchResults(this.selectQuery().where("ACCESS_TOKEN_EXPIRATION < ?", new Object[]{timestamp.toEpochMilli()}));
    }

    @Override
    @Nonnull
    public List<ClientTokenEntity> getRefreshTokensExpiringBefore(@Nonnull Instant timestamp) {
        return this.fetchResults(this.selectQuery().where("REFRESH_TOKEN_EXPIRATION < ?", new Object[]{timestamp.toEpochMilli()}));
    }

    private List<ClientTokenEntity> fetchResults(Query whereClause) {
        return Arrays.stream((AOClientToken[])this.activeObjects.find(AOClientToken.class, whereClause)).map(this::toEntity).collect(Collectors.toList());
    }

    private Optional<ClientTokenEntity> fetchFirstResult(Query whereClause) {
        return Arrays.stream((AOClientToken[])this.activeObjects.find(AOClientToken.class, whereClause)).map(this::toEntity).findFirst();
    }

    @Override
    @Nonnull
    public List<ClientTokenEntity> list() {
        return Arrays.stream((AOClientToken[])this.activeObjects.find(AOClientToken.class, Query.select().order("CONFIG_ID, ID ASC"))).map(this::toEntity).collect(Collectors.toList());
    }

    @Override
    public boolean deleteByTokenValue(String tokenValue) {
        return !this.deleteTokens(this.selectQuery().where("ACCESS_TOKEN = ? OR REFRESH_TOKEN = ?", new Object[]{tokenValue, tokenValue})).isEmpty();
    }

    private Query selectQuery() {
        return Query.select((String)String.join((CharSequence)", ", "ID", "CONFIG_ID", "ACCESS_TOKEN", "ACCESS_TOKEN_EXPIRATION", "REFRESH_TOKEN", "STATUS", "LAST_REFRESHED", "REFRESH_COUNT", "LAST_STATUS_UPDATED", "EXTERNAL_ID"));
    }

    private ClientTokenEntity toEntity(AOClientToken aoClientToken) {
        return ClientTokenEntity.builder().id(aoClientToken.getId()).configId(aoClientToken.getConfigId()).accessToken(aoClientToken.getAccessToken()).accessTokenExpiration(this.toInstant(aoClientToken.getAccessTokenExpiration())).refreshToken(aoClientToken.getRefreshToken()).refreshTokenExpiration(this.fromEpochMilli(aoClientToken.getRefreshTokenExpiration())).status(ClientTokenMetadata.ClientTokenStatus.valueOf((String)aoClientToken.getStatus())).lastRefreshed(this.fromEpochMilli(aoClientToken.getLastRefreshed())).lastStatusUpdated(this.fromEpochMilli(aoClientToken.getLastStatusUpdated())).refreshCount(aoClientToken.getRefreshCount()).externalId(aoClientToken.getExternalId()).build();
    }

    private Instant toInstant(long timestamp) {
        return Instant.ofEpochMilli(timestamp);
    }

    private ClientTokenEntity.Builder truncatedToMillis(ClientTokenEntity clientTokenEntity) {
        return ClientTokenEntity.builder((ClientTokenEntity)clientTokenEntity).accessTokenExpiration(clientTokenEntity.getAccessTokenExpiration().truncatedTo(ChronoUnit.MILLIS)).refreshTokenExpiration((Instant)Optional.ofNullable(clientTokenEntity.getRefreshTokenExpiration()).map(date -> date.truncatedTo(ChronoUnit.MILLIS)).orElse(null));
    }

    private Long toEpochMilli(@Nullable Instant instant) {
        return instant == null ? null : Long.valueOf(instant.toEpochMilli());
    }

    private Instant fromEpochMilli(@Nullable Long epochMillis) {
        return epochMillis == null ? null : Instant.ofEpochMilli(epochMillis);
    }
}

