/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.common.properties;

import jakarta.annotation.Nonnull;
import java.util.Objects;

public abstract class AbstractSystemProperty<T> {
    protected final String propertyName;
    protected final T defaultValue;

    protected AbstractSystemProperty(@Nonnull String propertyName, @Nonnull T defaultValue) {
        this.propertyName = Objects.requireNonNull(propertyName);
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    @Nonnull
    public String getName() {
        return this.propertyName;
    }

    @Nonnull
    public abstract T getValue();

    public void setValue(@Nonnull T value) {
        System.setProperty(this.propertyName, value.toString());
    }

    public void clearValue() {
        System.clearProperty(this.propertyName);
    }
}

