/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.auth.oauth2;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.core.auth.AbstractApplicationLinkResponseHandler;
import com.atlassian.applinks.oauth.auth.oauth2.AccessTokenKey;
import com.atlassian.cache.Cache;
import com.atlassian.oauth2.client.api.OAuth2Token;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.sal.api.net.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseOAuth2ApplicationLinkResponseHandler
extends AbstractApplicationLinkResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseOAuth2ApplicationLinkResponseHandler.class);
    private final AccessTokenKey accessTokenKey;
    private final String accessToken;
    private final Cache<AccessTokenKey, OAuth2Token> accessTokenCache;
    private final TokenHandler tokenHandler;
    protected boolean credentialsRequired = false;
    protected String authenticationProblem = null;
    protected String authenticationProblemAdvice = null;

    public BaseOAuth2ApplicationLinkResponseHandler(String url, ApplicationLinkRequest wrappedRequest, boolean followRedirects, AccessTokenKey accessTokenKey, String accessToken, Cache<AccessTokenKey, OAuth2Token> accessTokenCache, TokenHandler tokenHandler) {
        super(url, wrappedRequest, followRedirects);
        this.accessTokenKey = accessTokenKey;
        this.accessToken = accessToken;
        this.accessTokenCache = accessTokenCache;
        this.tokenHandler = tokenHandler;
    }

    protected void validateResponse(Response response) {
        if (response.getStatusCode() == 401 || response.getStatusCode() == 403) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Received {} response. Removing OAuth 2.0 token.", (Object)response.getStatusCode());
                }
                this.tokenHandler.deleteTokenByValue(this.accessToken);
            }
            catch (Exception e) {
                log.error("Failed to delete OAuth 2.0 token for key '{}'.", (Object)this.accessTokenKey, (Object)e);
            }
            this.accessTokenCache.remove((Object)this.accessTokenKey);
            if (response.getStatusCode() == 401) {
                this.credentialsRequired = true;
                this.authenticationProblem = "Authentication is required to access this resource.";
            } else {
                this.authenticationProblem = "You are not authorized to access this resource.";
            }
            this.authenticationProblemAdvice = "Please contact your administrator to get the necessary permissions.";
        }
    }
}

