/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.auth.threelo;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.auth.types.ThreeLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.oauth.auth.oauth2.AbstractOAuth2RequestFactory;
import com.atlassian.applinks.oauth.auth.oauth2.AccessTokenKey;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.cache.Cache;
import com.atlassian.oauth2.client.api.OAuth2Token;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.oauth2.client.api.storage.token.exception.RecoverableTokenException;
import com.atlassian.oauth2.client.api.storage.token.exception.UnrecoverableTokenException;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.user.UserManager;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreeLeggedOAuth2RequestFactoryImpl
extends AbstractOAuth2RequestFactory {
    private static final Logger log = LoggerFactory.getLogger(ThreeLeggedOAuth2RequestFactoryImpl.class);
    public static final String ACCESS_TOKEN_CACHE = ThreeLeggedOAuth2RequestFactoryImpl.class.getSimpleName() + ".accessTokenCache";
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;

    public ThreeLeggedOAuth2RequestFactoryImpl(ApplicationLink applicationLink, AuthenticationConfigurationManager authenticationConfigurationManager, UserManager userManager, RequestFactory requestFactory, TokenHandler tokenHandler, ApplicationProperties applicationProperties, Cache<AccessTokenKey, OAuth2Token> accessTokenCache) {
        super(applicationLink, requestFactory, tokenHandler, accessTokenCache);
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        boolean configured = authenticationConfigurationManager.isConfigured(applicationLink.getId(), ThreeLeggedOAuth2AuthenticationProvider.class);
        if (!configured) {
            throw new IllegalStateException(String.format("OAuth2 Authentication is not configured for application link %s", applicationLink));
        }
    }

    public URI getAuthorisationURI() {
        return this.getAuthorisationURI(null);
    }

    public URI getAuthorisationURI(URI callback) {
        UriBuilder uriBuilder = this.authorizationUriBuilder().queryParam("applinkId", new Object[]{this.applicationLink.getId()});
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        if (callback != null && callback.toString().startsWith(baseUrl)) {
            uriBuilder.queryParam("redirectUri", new Object[]{callback});
        }
        return uriBuilder.build(new Object[0]);
    }

    private UriBuilder authorizationUriBuilder() {
        return UriBuilder.fromUri((String)this.applicationProperties.getBaseUrl(UrlMode.CANONICAL)).path("/plugins/servlet/applinks/oauth2/initiate-flow");
    }

    @Override
    protected String getClientConfigurationId() {
        return this.applicationLink.getAuthorizationCodeClientConfigurationId();
    }

    @Override
    protected String getExternalId() {
        return Objects.requireNonNull(this.userManager.getRemoteUsername(), "You have to be logged in to use oauth authentication.");
    }

    @Override
    protected OAuth2Token refreshAccessToken() throws CredentialsRequiredException {
        try {
            OAuth2Token oAuth2Token = this.tokenHandler.getRefreshedToken(this.getExternalId(), this.getClientConfigurationId(), Duration.ofSeconds(30L));
            log.info("Successfully refreshed access token");
            return oAuth2Token;
        }
        catch (RecoverableTokenException | UnrecoverableTokenException e) {
            log.error("Failed to refresh access token", e);
            throw new CredentialsRequiredException((AuthorisationURIGenerator)this, "You do not have an authorized access token for the remote resource.");
        }
    }
}

