/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.auth.twolo;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.oauth.auth.oauth2.AbstractOAuth2RequestFactory;
import com.atlassian.applinks.oauth.auth.twolo.TwoLeggedOAuth2RequestFactoryImpl;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.auth.AuthenticationDirection;
import com.atlassian.applinks.spi.auth.AuthenticationProviderPluginModule;
import com.atlassian.applinks.spi.auth.IncomingTrustAuthenticationProviderPluginModule;
import com.atlassian.cache.CacheFactory;
import com.atlassian.oauth2.client.api.storage.ClientCredentialsTokenHandler;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.sal.api.net.RequestFactory;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.Version;

public class TwoLeggedOAuth2AuthenticatorProviderPluginModule
implements AuthenticationProviderPluginModule,
IncomingTrustAuthenticationProviderPluginModule {
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final RequestFactory requestFactory;
    private final TokenHandler tokenHandler;
    private final ClientCredentialsTokenHandler clientCredentialsTokenHandler;
    private final CacheFactory cacheFactory;

    public TwoLeggedOAuth2AuthenticatorProviderPluginModule(AuthenticationConfigurationManager authenticationConfigurationManager, RequestFactory requestFactory, TokenHandler tokenHandler, ClientCredentialsTokenHandler clientCredentialsTokenHandler, CacheFactory cacheFactory) {
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.requestFactory = requestFactory;
        this.tokenHandler = tokenHandler;
        this.clientCredentialsTokenHandler = clientCredentialsTokenHandler;
        this.cacheFactory = cacheFactory;
    }

    public AuthenticationProvider getAuthenticationProvider(ApplicationLink link) {
        TwoLeggedOAuth2AuthenticationProvider provider = null;
        if (this.authenticationConfigurationManager.isConfigured(link.getId(), TwoLeggedOAuth2AuthenticationProvider.class)) {
            provider = () -> new TwoLeggedOAuth2RequestFactoryImpl(link, this.authenticationConfigurationManager, this.requestFactory, this.tokenHandler, this.clientCredentialsTokenHandler, AbstractOAuth2RequestFactory.createDefaultAccessTokenCache(this.cacheFactory, TwoLeggedOAuth2RequestFactoryImpl.ACCESS_TOKEN_CACHE));
        }
        return provider;
    }

    public String getConfigUrl(ApplicationLink link, Version applicationLinksVersion, AuthenticationDirection direction, HttpServletRequest request) {
        return null;
    }

    public Class<? extends AuthenticationProvider> getAuthenticationProviderClass() {
        return TwoLeggedOAuth2AuthenticationProvider.class;
    }

    public boolean incomingEnabled(ApplicationLink applicationLink) {
        return StringUtils.isNotBlank((CharSequence)applicationLink.getClientId());
    }
}

