/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theme.internal;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.theme.api.Theme;
import com.atlassian.theme.api.ThemeColorMode;
import com.atlassian.theme.internal.DefaultThemes;
import com.atlassian.theme.internal.api.ThemeService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ReturnValuesAreNonnullByDefault
public class DefaultThemeService
implements ThemeService {
    public List<Theme> getAllAvailableThemes() {
        return Arrays.asList(DefaultThemes.DARK, DefaultThemes.LIGHT, DefaultThemes.ORIGINAL);
    }

    public Optional<Theme> findMatchingTheme(@Nonnull ThemeColorMode themeColorMode, @Nullable String themeKey) {
        Objects.requireNonNull(themeColorMode, "themeColorMode");
        if (Objects.isNull(themeKey)) {
            return Optional.empty();
        }
        return this.getAllAvailableThemes().stream().filter(theme -> themeColorMode.equals((Object)theme.getColorMode())).filter(theme -> themeKey.equals(theme.getThemeKey())).findFirst();
    }
}

