/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.request;

import com.atlassian.oauth2.scopes.api.Closeable;
import com.atlassian.oauth2.scopes.api.Permission;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.oauth2.scopes.api.ScopesRequestCache;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultScopesRequestCache
implements ScopesRequestCache {
    private static final Logger logger = LoggerFactory.getLogger(DefaultScopesRequestCache.class);
    protected static final List<Permission> EMPTY_PERMISSIONS = new ArrayList<Permission>();
    protected final ScopeResolver scopeResolver;
    private final ThreadLocal<ScopesRequestCache.RequestCache> requestCacheThreadLocal = new InheritableThreadLocal<ScopesRequestCache.RequestCache>(this){

        @Override
        protected ScopesRequestCache.RequestCache initialValue() {
            return new ScopesRequestCache.RequestCache();
        }
    };

    protected DefaultScopesRequestCache(ScopeResolver scopeResolver) {
        this.scopeResolver = scopeResolver;
    }

    public boolean requestHasGrantsForAll(Set<String> scopes) {
        return scopes.stream().allMatch(this::isScopePermitted);
    }

    public boolean requestHasGrantsForAny(Set<String> scopes) {
        return scopes.stream().anyMatch(this::isScopePermitted);
    }

    public Set<Scope> getScopesGrantedForRequest() {
        return this.getRequestCache().getScopes();
    }

    public boolean isScopeApplicableFor2LO(String scopeKey) {
        return this.isScopesApplicable("client_credentials", scopeKey);
    }

    public boolean isScopeApplicableFor3LO(String scopeKey) {
        return this.isScopesApplicable("authorization_code", scopeKey);
    }

    public boolean isScopePermitted(String scopeKey) {
        if (this.getRequestCache() != null) {
            return this.getRequestCache().getScopes().stream().anyMatch(scope -> scope.getName().equals(scopeKey));
        }
        return false;
    }

    public Closeable withScopes(Scope scope, Supplier<Optional<String>> applicationNameSupplier) {
        this.setRequestCache(new ScopesRequestCache.RequestCache(this.getPermissions(scope), applicationNameSupplier, DefaultScopesRequestCache.getScopes(scope)));
        return this::clearRequestCache;
    }

    public Closeable withScopes(Set<Scope> scopes, Supplier<Optional<String>> applicationNameSupplier) {
        Set<Object> scopesToSet = scopes == null ? Collections.emptySet() : scopes;
        List permissions = scopesToSet.stream().flatMap(s -> this.getPermissions((Scope)s).stream()).toList();
        this.setRequestCache(new ScopesRequestCache.RequestCache(permissions, applicationNameSupplier, scopesToSet));
        return this::clearRequestCache;
    }

    protected abstract List<Permission> getPermissions(Scope var1);

    private static Set<Scope> getScopes(Scope scope) {
        if (scope == null) {
            return Collections.emptySet();
        }
        return scope.getScopeAndInheritedScopes();
    }

    public boolean containsOnlyThisScope(Scope scope) {
        Set scopes = this.requestCacheThreadLocal.get().getScopes();
        return scopes.contains(scope) && scopes.size() == 1;
    }

    public boolean hasPermission(Permission permission) {
        Set permissions = this.requestCacheThreadLocal.get().getPermissions();
        return permissions.isEmpty() || permissions.contains(permission);
    }

    public boolean hasPermission(String permission) {
        Set permissions = this.requestCacheThreadLocal.get().getPermissions();
        return permissions.isEmpty() || permissions.stream().anyMatch(p -> p.hasPermission(permission));
    }

    @Nonnull
    public Optional<String> getApplicationNameForRequest() {
        return (Optional)this.requestCacheThreadLocal.get().getApplicationNameSupplier().get();
    }

    @Nonnull
    public Set<Permission> getPermissionsForRequest() {
        return ImmutableSet.copyOf((Collection)this.requestCacheThreadLocal.get().getPermissions());
    }

    public ScopesRequestCache.RequestCache getRequestCache() {
        return this.requestCacheThreadLocal.get().copy();
    }

    public void setRequestCache(@Nullable ScopesRequestCache.RequestCache requestCache) {
        if (requestCache != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Storing permissions [{}] to scope request cache for application name [{}].", (Object)requestCache.getPermissions(), (Object)requestCache.getApplicationNameSupplier());
            }
            this.requestCacheThreadLocal.set(requestCache.copy());
        } else {
            logger.debug("Request Cache set to null value");
            this.clearRequestCache();
        }
    }

    public void clearRequestCache() {
        this.requestCacheThreadLocal.remove();
        logger.debug("Removing all permissions from scope request cache.");
    }

    private boolean isScopesApplicable(String grantType, String scopeKey) {
        return this.scopeResolver.getAvailableScopes().stream().filter(scope -> scope.getSupportedGrantTypes().contains(grantType)).anyMatch(scope -> scope.getName().equals(scopeKey));
    }
}

