/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.request.basic;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.oauth2.scopes.api.Permission;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.oauth2.scopes.request.basic.BasicScope;
import com.atlassian.oauth2.scopes.request.basic.BasicScopeRequestCache;
import com.atlassian.oauth2.scopes.request.custom.CustomPermissionMapperService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraScopesRequestCache
extends BasicScopeRequestCache {
    private static final Logger log = LoggerFactory.getLogger(JiraScopesRequestCache.class);
    static final String SERVICE_DESK_AGENT_PERMISSION_KEY = "SERVICEDESK_AGENT";
    @VisibleForTesting
    final Set<ProjectPermissionKey> allProjectPermissionKeys;
    @VisibleForTesting
    final Set<GlobalPermissionKey> allGlobalPermissionKeys;
    private final CustomPermissionMapperService customPermissionMapperService;

    public JiraScopesRequestCache(ScopeResolver scopeResolver, CustomPermissionMapperService customPermissionMapperService) {
        super(scopeResolver);
        this.customPermissionMapperService = customPermissionMapperService;
        this.allProjectPermissionKeys = ImmutableSet.copyOf((Collection)Arrays.stream(ProjectPermissions.class.getFields()).filter(projectPermissionField -> projectPermissionField.getType().equals(ProjectPermissionKey.class)).map(projectPermissionField -> {
            try {
                return (ProjectPermissionKey)projectPermissionField.get(null);
            }
            catch (IllegalAccessException e) {
                log.warn("Failed to resolve project permission field [" + String.valueOf(projectPermissionField) + "]");
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet()));
        this.allGlobalPermissionKeys = ImmutableSet.copyOf((Collection)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.values());
    }

    private List<Permission> fetchCustomPermissionMappingsForScope(BasicScope scope) {
        return this.customPermissionMapperService.getScopeMappings().entrySet().stream().filter(JiraScopesRequestCache.mappingInScope(scope)).flatMap(JiraScopesRequestCache.mappingToPermissionNameSet()).map(Permission::permission).collect(Collectors.toList());
    }

    @Nonnull
    private static Function<Map.Entry<String, Set<String>>, Stream<? extends String>> mappingToPermissionNameSet() {
        return entry -> ((Set)entry.getValue()).stream();
    }

    @Nonnull
    private static Predicate<Map.Entry<String, Set<String>>> mappingInScope(BasicScope scope) {
        return entry -> ((String)entry.getKey()).equalsIgnoreCase(scope.name());
    }

    @Override
    protected List<Permission> systemAdminPermission() {
        return ImmutableList.builder().addAll(this.adminPermission()).addAll(this.fetchCustomPermissionMappingsForScope(BasicScope.SYSTEM_ADMIN)).add((Object)Permission.permission((String)GlobalPermissionKey.SYSTEM_ADMIN.getKey())).build();
    }

    @Override
    protected List<Permission> adminPermission() {
        return ImmutableList.builder().addAll(this.writePermission()).addAll(this.fetchCustomPermissionMappingsForScope(BasicScope.ADMIN)).add((Object)Permission.permission((String)GlobalPermissionKey.ADMINISTER.getKey())).add((Object)Permission.permission((String)ProjectPermissions.ADMINISTER_PROJECTS.permissionKey())).build();
    }

    @Override
    protected List<Permission> writePermission() {
        return ImmutableList.builder().addAll(this.getAllGlobalPermissionsExceptAdmin()).addAll(this.fetchCustomPermissionMappingsForScope(BasicScope.WRITE)).addAll(this.getAllProjectPermissionsExceptAdmin()).build();
    }

    Collection<Permission> getAllProjectPermissionsExceptAdmin() {
        return Stream.concat(this.allProjectPermissionKeys.stream().filter(projectPermissionKey -> !ProjectPermissions.ADMINISTER_PROJECTS.equals(projectPermissionKey)).map(projectPermissionKey -> Permission.permission((String)projectPermissionKey.permissionKey())), Stream.of(Permission.permission((String)SERVICE_DESK_AGENT_PERMISSION_KEY))).collect(Collectors.toSet());
    }

    Collection<Permission> getAllGlobalPermissionsExceptAdmin() {
        return this.allGlobalPermissionKeys.stream().filter(globalPermissionKey -> !GlobalPermissionKey.ADMINISTER.equals(globalPermissionKey) && !GlobalPermissionKey.SYSTEM_ADMIN.equals(globalPermissionKey)).map(globalPermissionKey -> Permission.permission((String)globalPermissionKey.getKey())).collect(Collectors.toSet());
    }

    @Override
    protected List<Permission> readPermission() {
        return Stream.concat(Stream.of(Permission.permission((String)ProjectPermissions.VIEW_DEV_TOOLS.permissionKey()), Permission.permission((String)ProjectPermissions.VIEW_READONLY_WORKFLOW.permissionKey()), Permission.permission((String)ProjectPermissions.VIEW_VOTERS_AND_WATCHERS.permissionKey()), Permission.permission((String)ProjectPermissions.BROWSE_PROJECTS.permissionKey()), Permission.permission((String)ProjectPermissions.BROWSE_ARCHIVE.permissionKey()), Permission.permission((String)SERVICE_DESK_AGENT_PERMISSION_KEY)), this.fetchCustomPermissionMappingsForScope(BasicScope.READ).stream()).collect(Collectors.toList());
    }
}

