/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.request.crowd;

import com.atlassian.oauth2.scopes.api.Scope;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public enum CrowdScope implements Scope
{
    APPLICATION("APPLICATION", Collections.emptySet(), (Set<String>)ImmutableSet.of((Object)"client_credentials")),
    USER("USER", Collections.emptySet(), (Set<String>)ImmutableSet.of((Object)"authorization_code")),
    SYSTEM_ADMIN("SYSTEM_ADMIN", (Set<Scope>)ImmutableSet.of((Object)((Object)USER)), (Set<String>)ImmutableSet.of((Object)"authorization_code"));

    private final String name;
    private final Set<Scope> inheritedScopes;
    private final Set<String> supportedGrantTypes;

    private CrowdScope(String name, Set<Scope> inheritedScopes, Set<String> supportedGrantTypes) {
        this.name = name;
        this.supportedGrantTypes = Collections.unmodifiableSet(supportedGrantTypes);
        HashSet<Scope> mutableInheritedScopes = new HashSet<Scope>(inheritedScopes);
        mutableInheritedScopes.add(this);
        this.inheritedScopes = Set.copyOf(mutableInheritedScopes);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Set<Scope> getScopeAndInheritedScopes() {
        return this.inheritedScopes;
    }

    public Set<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public String toString() {
        return this.name;
    }
}

