/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.request.custom;

import com.atlassian.oauth2.scopes.request.custom.CustomPermission;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CustomPermissionDescriptor
extends AbstractModuleDescriptor<Set<CustomPermission>> {
    public static final String XML_ELEMENT_NAME = "oauth2-custom-permission";
    private Set<CustomPermission> customPermissionsSet;

    public CustomPermissionDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        List permission = element.elements("permission");
        if (permission == null) {
            throw new PluginParseException("Missing permission element");
        }
        this.customPermissionsSet = permission.stream().map(this::parsePermission).collect(Collectors.toSet());
    }

    private CustomPermission parsePermission(Element permission) throws PluginParseException {
        String permissionKey = permission.attributeValue("permission-key");
        String scope = permission.attributeValue("scope");
        if (permissionKey == null || scope == null) {
            throw new PluginParseException("Missing permission-key or scope attribute");
        }
        return new CustomPermission(permissionKey, scope);
    }

    public Set<CustomPermission> getModule() {
        return this.customPermissionsSet;
    }

    public String getDisplayName() {
        return "Custom Permission Mappings";
    }
}

