/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.scopes.web;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.oauth2.scopes.api.ScopesRequestCache;
import com.atlassian.oauth2.scopes.request.basic.BasicScope;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ReadWriteScopeFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ReadWriteScopeFilter.class);
    private final ScopesRequestCache scopesRequestCache;

    public ReadWriteScopeFilter(ScopesRequestCache scopesRequestCache) {
        this.scopesRequestCache = scopesRequestCache;
    }

    public void init(FilterConfig filterConfig) {
        logger.info("Initializing: [{}]", (Object)ReadWriteScopeFilter.class.getSimpleName());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.isReadScope()) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            if (!"GET".equalsIgnoreCase(httpServletRequest.getMethod())) {
                logger.debug("Request does not have the required scope to complete request");
                httpServletResponse.sendError(403, "Request does not have write scope. Cannot complete " + httpServletRequest.getMethod() + " request.");
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private boolean isReadScope() {
        return this.scopesRequestCache.containsOnlyThisScope((Scope)BasicScope.READ);
    }

    public void destroy() {
        logger.info("Destroying: [{}]", (Object)ReadWriteScopeFilter.class.getSimpleName());
    }
}

